import Vue from 'vue'
import Router from 'vue-router'
import Layout from '../layout/index'

Vue.use(Router)

export const constantRouterMap = [
  { path: '/login',
    meta: { title: '登录', noCache: true },
    component: (resolve) => require(['@/views/homepage/login'], resolve),
    hidden: true
  },
  { path: '/backlogin',
    meta: { title: '后台登录', noCache: true },
    component: (resolve) => require(['@/views/login'], resolve),
    hidden: true
  },
  {
    path: '/404',
    component: (resolve) => require(['@/views/features/404'], resolve),
    hidden: true
  },
  {
    path: '/401',
    component: (resolve) => require(['@/views/features/401'], resolve),
    hidden: true
  },
  {
    path: '/redirect',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '/redirect/:path*',
        component: (resolve) => require(['@/views/features/redirect'], resolve)
      }
    ]
  },
  {
    path: '/home',
    meta: { title: '首页', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/index'], resolve)
    },
    hidden: true
  },
  {
    path: '/product',
    meta: { title: '优质产品', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/product/index'], resolve)
    },
    hidden: true
  },
  {
    path: '/product/details/:id',
    meta: { title: '产品详情', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/product/details'], resolve)
    },
    hidden: true
  },
  {
    path: '/product/hardware/:type',
    meta: { title: '硬件产品', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/product/hardware'], resolve)
    },
    hidden: true
  },
  {
    path: '/supplier',
    meta: { title: '优质供应商', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/supplier/index'], resolve)
    },
    hidden: true
  },
  {
    path: '/supplier/details/:id',
    meta: { title: '供应商黄页', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/supplier/details'], resolve)
    },
    hidden: true
  },
  {
    path: '/project',
    meta: { title: '解决方案与服务', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/project/index'], resolve)
    },
    hidden: true
  },
  {
    path: '/software',
    meta: { title: '软件系统', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/software/index'], resolve)
    },
    hidden: true
  },
  {
    path: '/course',
    meta: { title: '专业培训', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/course/index'], resolve)
    },
    hidden: true
  },
  {
    path: '/information',
    meta: { title: '行业资讯', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/information/index'], resolve)
    },
    hidden: true
  },
  {
    path: '/information/details/:id',
    meta: { title: '资讯详情', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/information/details'], resolve)
    },
    hidden: true
  },
  {
    path: '/publish',
    meta: { title: '信息发布', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/publish/index'], resolve)
    },
    hidden: true
  },
  {
    path: '/publish/supplyInfo/:type',
    meta: { title: '供应产品详情', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/publish/supplyInfo'], resolve)
    },
    hidden: true
  },
  {
    path: '/publish/buyInfo/:type',
    meta: { title: '求购产品详情', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/publish/buyInfo'], resolve)
    },
    hidden: true
  },
  {
    path: '/publish/otherInfo',
    meta: { title: '留言页', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/publish/otherInfo'], resolve)
    },
    hidden: true
  },
  {
    path: '/console',
    meta: { title: '个人中心', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/console/index'], resolve)
    },
    hidden: true
  },
  {
    path: '/console/registerInfo',
    meta: { title: '用户注册信息', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/console/registerInfo'], resolve)
    },
    hidden: true
  },
  {
    path: '/console/userInfo',
    meta: { title: '个人中心-用户信息', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/console/userInfo'], resolve)
    },
    hidden: true
  },
  {
    path: '/console/product',
    meta: { title: '个人中心-产品管理', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/console/product'], resolve)
    },
    hidden: true
  },
  {
    path: '/console/collectPro',
    meta: { title: '个人中心-收藏的产品', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/console/collectPro'], resolve)
    },
    hidden: true
  },
  {
    path: '/console/collectSup',
    meta: { title: '个人中心-收藏的供应商', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/console/collectSup'], resolve)
    },
    hidden: true
  },
  {
    path: '/console/replyLog',
    meta: { title: '个人中心-被询价记录', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/console/replyLog'], resolve)
    },
    hidden: true
  },
  {
    path: '/console/askLog',
    meta: { title: '个人中心-询价记录', noCache: true },
    component: (resolve) => {
      return require(['@/views/homepage/console/askLog'], resolve)
    },
    hidden: true
  },
  {
    path: '/backstage',
    component: Layout,
    redirect: '/dashboard',
    children: [
      {
        path: 'dashboard',
        component: (resolve) => require(['@/views/home'], resolve),
        name: 'Dashboard',
        meta: { title: '首页', icon: 'index', affix: true, noCache: true }
      }
    ]
  },
  {
    path: '/user',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'center',
        component: (resolve) => require(['@/views/system/user/center'], resolve),
        name: '个人中心',
        meta: { title: '个人中心' }
      }
    ]
  }
]

export default new Router({
  // mode: 'hash',
  mode: 'history',
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRouterMap
})
