import request from '@/utils/request'
import qs from 'qs'

export const HttpReq = {
  // 后台管理接口列表
  backstageApi: {
    // 上传营业执照图片
    uploadBusinessLicense: function(data) {
      return request({
        url: '/api/bsw/users/uploadBusinessLicense',
        method: 'post',
        data: data
      }).then((res) => {
        return res
      })
    },
    deleteBusinessLicense: function(data) {
      return request({
        url: '/api/bsw/users/deleteBusinessLicense',
        method: 'delete',
        data: data
      }).then((res) => {
        return res
      })
    },
    deletePicture: function(data) {
      return request({
        url: '/api/bsw/common/deletePicture',
        method: 'delete',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 获取行政区划
    findAreaByCodeAndType: function(params) {
      return request({
        url: '/api/bsw/users/findAreaByCodeAndType?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 添加客户信息
    addCustomer: function(data) {
      return request({
        url: '/api/bsw/users/addCustomer',
        method: 'post',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 修改客户信息
    updateCustomerDetail: function(data) {
      return request({
        url: '/api/bsw/users/updateCustomerDetail',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 获取客户列表
    queryCustomer: function(params) {
      return request({
        url: '/api/bsw/users/queryCustomer?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 客户信息详情
    queryCustomerDetail: function(params) {
      return request({
        url: '/api/bsw/users/queryCustomerDetail?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 批量禁用启用客户
    userEnableDisable: function(data) {
      return request({
        url: '/api/bsw/users/enableDisable',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 客户信息审核
    reviewCustomer: function(data) {
      return request({
        url: '/api/bsw/users/reviewCustomer',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 上传产品图片
    uploadProductPic: function(data) {
      return request({
        url: '/api/bsw/product/uploadProductPic',
        method: 'post',
        data: data
      }).then((res) => {
        return res
      })
    },
    deleteProductPic: function(data) {
      return request({
        url: '/api/bsw/product/deleteProductPic',
        method: 'delete',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 联想查询供应商名称
    associateQueryEnterpriseName: function(params) {
      return request({
        url: '/api/bsw/product/associateQueryEnterpriseName?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    checkEnterpriseName: function(params) {
      return request({
        url: '/api/bsw/product/checkEnterpriseName?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 添加产品详情
    addProduct: function(data) {
      return request({
        url: '/api/bsw/product/addProduct',
        method: 'post',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 更新产品详情
    updateProductDetail: function(data) {
      return request({
        url: '/api/bsw/product/updateProductDetail',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 查询产品列表
    queryProduct: function(params) {
      return request({
        url: '/api/bsw/product/queryProduct?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 查询产品详情
    queryProductDetail: function(params) {
      return request({
        url: '/api/bsw/product/queryProductDetail?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 客户信息审核
    reviewProduct: function(data) {
      return request({
        url: '/api/bsw/product/reviewProduct',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 批量上下架产品
    batchReleaseAndRecovery: function(data) {
      return request({
        url: '/api/bsw/product/batchReleaseAndRecovery',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 查询咨询信息列表
    queryInformation: function(params) {
      return request({
        url: '/api/bsw/information/queryInformation?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 查询咨询信息详情
    queryInformationDetail: function(params) {
      return request({
        url: '/api/bsw/information/queryInformationDetail?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 批量处理咨询
    batchInformationProcessing: function(data) {
      return request({
        url: '/api/bsw/information/batchInformationProcessing',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-新增供应商列表页面
    addSupplierListPage: function(data) {
      return request({
        url: '/api/bsw/supplierListPage/addSupplierListPage',
        method: 'post',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-修改供应商列表页中供应商详情（排序、展示产品）
    updateSupplierListPage: function(data) {
      return request({
        url: '/api/bsw/supplierListPage/updateSupplierListPage',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-供应商列表批量发布
    releaseSupplierListPage: function(data) {
      return request({
        url: '/api/bsw/supplierListPage/releaseSupplierListPage',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-查询单个供应商列表页
    querySupplierListPageById: function(params) {
      return request({
        url: '/api/bsw/supplierListPage/querySupplierListPageById?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 内容管理-供应商列表查询
    querySupplierListPage: function(params) {
      return request({
        url: '/api/bsw/supplierListPage/querySupplierListPage?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 内容管理-查询产品列表页
    queryProductListPage: function(params) {
      return request({
        url: '/api/bsw/productListPage/queryProductListPage?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 内容管理-查询单个产品列表页
    queryProductListPageById: function(params) {
      return request({
        url: '/api/bsw/productListPage/queryProductListPageById?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 内容管理-修改产品列表
    updateProductListPage: function(data) {
      return request({
        url: '/api/bsw/productListPage/updateProductListPage',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-产品列表批量发布
    releaseProductListPage: function(data) {
      return request({
        url: '/api/bsw/productListPage/releaseProductListPage',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-查询首页内容列表页
    queryHomePage: function(params) {
      return request({
        url: '/api/bsw/homePage/queryHomePage?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 内容管理-查询单个首页内容列表页
    queryHomePageById: function(params) {
      return request({
        url: '/api/bsw/homePage/queryHomePageById?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 内容管理-新增首页内容
    addHomePage: function(data) {
      return request({
        url: '/api/bsw/homePage/addHomePage',
        method: 'post',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-修改首页内容
    updateHomePage: function(data) {
      return request({
        url: '/api/bsw/homePage/updateHomePage',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-首页管理批量发布
    releaseHomePage: function(data) {
      return request({
        url: '/api/bsw/homePage/releaseHomePage',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-首页管理批量删除
    hpBatchDelete: function(data) {
      return request({
        url: '/api/bsw/homePage/batchDelete',
        method: 'delete',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-查询资讯页内容
    queryNewsPage: function(params) {
      return request({
        url: '/api/bsw/newsPage/queryNewsPage?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 内容管理-查询单个资讯页内容
    queryNewsPageById: function(params) {
      return request({
        url: '/api/bsw/newsPage/queryNewsPageById?' + qs.stringify(params, { indices: false }),
        method: 'get'
      })
    },
    // 内容管理-资讯发布
    releaseNewsPage: function(data) {
      return request({
        url: '/api/bsw/newsPage/releaseNewsPage',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-修改资讯
    updateNewsPage: function(data) {
      return request({
        url: '/api/bsw/newsPage/updateNewsPage',
        method: 'put',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-新增资讯
    addNewsPage: function(data) {
      return request({
        url: '/api/bsw/newsPage/addNewsPage',
        method: 'post',
        data: data
      }).then((res) => {
        return res
      })
    },
    // 内容管理-删除资讯
    newsBatchDelete: function(data) {
      return request({
        url: '/api/bsw/newsPage/batchDelete',
        method: 'delete',
        data: data
      }).then((res) => {
        return res
      })
    },
    xxx: null
  }
}

