import Vue from 'vue'
import { resErrorDeal } from './util.js'
import msgTip from "./msgTip.js"

const BASEURL = 'http://192.168.3.23:8086' // 研发环境url
console.log(resErrorDeal)
export default {
	/**
	 * 封装请求（async await 封装uni.request）
	 */
	async call(paramObj) {
		let resultObj = false, cb = paramObj.cb;
		const header = {	
			'Accept':'application/json, text/plain, */*',
			'Authorization':'Bearer ' + JSON.parse(uni.getStorageSync('userInfo')).token
		}
		
		let opt = {
			url: BASEURL + paramObj.url, // 域名+接口地址
			data: 	paramObj.data,
			method: paramObj.method || 'GET',
			loadFlag: paramObj.loadFlag === "N" ? false : true ,// 默认带有加载条
			timeout: paramObj.timeout || 1200000, // 默认登录超时时间20min
			sslVerify: false,
			header
		}
		
		if (opt.loadFlag) { //  请求是加载进度条
			msgTip.showLoading()
		}
		console.log('请求信息', JSON.stringify(opt))
		
		let [error, response] = await uni.request(opt);
		
		if(response === undefined){
			msgTip.toast('网络错误')
			msgTip.showLoading(false)
			return
		}
		if(!response.data){
			msgTip.toast('网络错误')
			msgTip.showLoading(false)
			return
		}
		
		const resData = response.data
		if(resData.code === 200){
			cb && cb(resData) // 自定义处理回调函数
			if(paramObj.showSuccessTip){ // 成功调用接口时，默认不显示提醒信息
				msgTip.toast(resData.message)
			}
		}else{
			resErrorDeal(response)
		}
		uni.hideLoading()
		console.log('登录响应信息', response)
	},
}