/**
 * 确认提示框
 */
	const confirmModal = (config) => {
		uni.showModal({
			title: config.title || '信息提示',
			content: config.content || '确认要继续该操作吗',
			showCancel: config.showCancel !== 'NO',
			confirmText: config.confirmText || '确定',
			cancelText: config.cancelText ||'取消',
			success: (res) => {
				console.log('***confirmmodasl**', res)
				if (res.confirm) {
					config.cb && config.cb(true)
				} else if (res.cancel) {
					config.cb && config.cb(false)
				}
			}
		});
	}
	
	/**
	 * 显示提示框
	 */
	const toast = (title, icon = 'none', duration = 2800) => {
		setTimeout(()=>{  
			uni.showToast({
				title,
				icon,
				duration //显示时间
			});
		}, 0)
	}
	
	const showLoading = (showFlag = true) => {
		if(showFlag){
			uni.showLoading({
				title: '正在加载中...',
				mask: true
			});
		}else{
			uni.hideLoading()
		}
	}
	const hideKeyboard = () => {
		uni.hideKeyboard()
	}
export default {
	confirmModal,
	toast,
	showLoading,
	hideKeyboard
}