import App from './App'
import store from './store'
import util from './common/util.js'
import API from '@/common/api.js'
import msgTip from "@/common/msgTip.js"

// #ifndef VUE3
import Vue from 'vue'

// const BASEURL = 'http://117.34.103.191:8086' // 生产环境url
const BASEURL = 'http://192.168.3.23:8086' // 研发环境url
Vue.prototype.$BASEURL = BASEURL
Vue.prototype.$UTIL = util
Vue.prototype.$API = API
Vue.prototype.$TIP = msgTip



Vue.config.productionTip = false
Vue.prototype.$store = store
Vue.prototype.$adpid = "1111111111"
Vue.prototype.$backgroundAudioData = {
	playing: false,
	playTime: 0,
	formatedPlayTime: '00:00:00'
}
App.mpType = 'app'
const app = new Vue({
	store,
	...App
})
app.$mount()
// #endif

// #ifdef VUE3
import {
	createSSRApp
} from 'vue'
export function createApp() {
	const app = createSSRApp(App)
	app.use(store)
	app.config.globalProperties.$adpid = "1111111111"
	app.config.globalProperties.$backgroundAudioData = {
		playing: false,
		playTime: 0,
		formatedPlayTime: '00:00:00'
	}
	return {
		app
	}
}
// #endif
