/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				previewUrl: axios.defaults.baseURL,
				form: {
					id: '',
					companyId: '',
					name: "",
					workTime1: "",
					workTime2: "",
					workTime: '',
					workNumber: '',
					mainPlace: '',
					reportPer: '',
					perTel: '',
					remark: '',
					uploadDate: "",
					filePathList: [] // 'dangerjob/e40eda16-7a86-4a2a-976b-892e17eeed49.pdf'

				},
				// 企业id
				companyId: localStorage.getItem('companyId'),
				disabled: false,
				pageType: '',
				// 检查日期的模态框
				hdInspectDateModel1: '', // 时间的临时model值
				showPopup4hdInspectDate1: false,
				// 检查日期的模态框
				hdInspectDateModel2: '', // 时间的临时model值
				showPopup4hdInspectDate2: false,

				// 整改日期模态框
				hdRectificationDateModel: '',
				showPopup4hdRectificationDate: false,

				fileList: [],
			}
		},
		mounted() {
			if (gemhoUtil.getParameter('type') === 'detail') {
				this.disabled = true
				this.pageType = 'detail'
				this.detail()
			} else if (gemhoUtil.getParameter('type') === 'edit') {
				this.disabled = false
				this.pageType = 'edit'
				this.detail()
			} else { // 新增
				this.disabled = true
				this.pageType = 'add'
				this.resetData()
			}
		},

		methods: {
			previewFile(){
				// var src = 'dangerjob/e40eda16-7a86-4a2a-976b-892e17eeed49.pdf'
				// location.href = './pdfViewer.html?pdfSrc='+ src
				console.log(this.previewUrl + '/' + this.form.filePathList[0])
				location.href = this.previewUrl + '/' + this.form.filePathList[0]
			},
			beforeUpload(file) {
				console.log('beforeUpload',file)
				// 在文件上传之前的处理逻辑，例如校验文件大小、文件类型等
				return true; // 返回 true 继续上传，返回 false 中止上传
			},
			afterRead(file) {
				console.log('afterRead',file)
				// 文件读取完成后的处理逻辑
				const formData = new FormData();
				formData.append('file', file.file); // 通过FormData构建要上传的文件数据
				formData.append('modelName', 'dangerjob');

				// 发送HTTP POST请求
				fetch(this.previewUrl + '/api/common/upload', {
						method: 'POST',
						body: formData
					})
					.then(response => {
						if (response.ok) {
							return response.json();
						}
						throw new Error('Network response was not ok.');
					})
					.then(data => {
						console.log(data); // 处理后端返回的数据
						// 可根据后端返回的数据做进一步处理，如显示上传成功信息等
						this.form.filePathList = data.body ? [data.body] : []
					})
					.catch(error => {
						console.error('There has been a problem with your fetch operation:', error);
					});
			},
			resetData() {
				// 使用 Object.assign 来重写 this.$data，以达到重置 data 的目的
				Object.assign(this.$data, this.$options.data.call(this));
			},
			showPopup(popupType) {
				if (!this.disabled) {
					this[popupType] = true
				}
			},
			detail() {
				http2.post({
					serviceId: API_KEY_MAP["dw-list"]['id'],
					interfacePublicKey: API_KEY_MAP["dw-list"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["dw-list"]["privateKey"],
					reqParams: {
						id: gemhoUtil.getParameter('dwId'),
					}
				}, (res) => {
						
					if(res){
						console.log('接口回调数据', JSON.parse(res))
						
						var result = JSON.parse(res)
						// this.noticeContent = result.noticeContent
							this.form = result.content[0]
							this.form.filePathList = result.content[0].filePathList || []
							if(this.form.workTime && this.form.workTime.length){
								this.form.workTime1 = this.form.workTime[0]
								this.form.workTime2 = this.form.workTime[1]
							}
					}
				})
				// http.get('/api/dangerJobReport/page', {
				// 	page: 0, // 每次请求增加下一页
				// 	size: 1,
				// 	// companyId: localStorage.getItem('companyId'),
				// 	id: gemhoUtil.getParameter('dwId'),
				// 	sort: 'id,asc',
				// }).then((res) => {
				// 	console.log('响应结果', res.content)
				// 	this.form = res.content[0]
				// 	this.form.filePathList = res.content[0].filePathList || []
				// 	if(this.form.workTime && this.form.workTime.length){
				// 		this.form.workTime1 = this.form.workTime[0]
				// 		this.form.workTime2 = this.form.workTime[1]
				// 	}
				// })
			},
			submit() {
				if (!this.form.name) {
					vant.Dialog.alert({
						message: '请输入危险作业备案名称',
					})
					return;
				}
				if (!this.form.workTime1 || !this.form.workTime2) {
					vant.Dialog.alert({
						message: '请选择作业时间',
					})
					return;
				}
				// let formData = new FormData()
				// for (const key of Object.keys(this.form)) {
				// 	formData.append(key, this.form[key]);
				// }
				this.form.companyId = this.companyId
				this.form.workTime = [this.form.workTime1, this.form.workTime2]

				var url = "/api/dangerJobReport/create"

				http.post(url, this.form).then((res) => {
					console.log('添加结果', res)
					vant.Toast({
						message: '操作成功',
					})
					if (!this.form.id) { // 添加时则
						location.reload()
					}
				})
			},
			formatDate(date, type) {
				var ymd =
					`${date.getFullYear() + 1}-${((date.getMonth()+1)>9?'':'0')+(date.getMonth() + 1)}-${(date.getDate()>9?'':'0')+date.getDate()}`;
				if (type === 'YYYY-MM-DD HH:MM:SS') {
					return ymd + ' 00:00:00';
				}
				return ymd
			},
			confirm4hdInspectDate1(value) {
				console.log('value', value)
				this.form.workTime1 = this.formatDate(new Date(value))
				this.showPopup4hdInspectDate1 = false

			},
			confirm4hdInspectDate2(value) {
				console.log('value', value)
				this.form.workTime2 = this.formatDate(new Date(value))
				this.showPopup4hdInspectDate2 = false
			
			},
			confirm4hdRectificationDate(value) {
				console.log('value', value)
				this.form.uploadDate = this.formatDate(new Date(value))
				this.showPopup4hdRectificationDate = false

			},
		},
	});
});