/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				form: {
					id: "",
					// companyIds: [],
					// 企业id
					planName: "",
					// 验收人
					publishDate: "",
					// 隐患描述
					publishDeptName: "",
					publishDesc: "",
					filePathList: [],
					completionDate: "",
					issueDescription: "",
					processDescription: "",
				},
				// 整改日期模态框
				completionDate: '',
				showPopup4completionDate: false,
				// companyId: localStorage.getItem('companyId'),
				previewUrl: axios.defaults.baseURL,
				disabled: false,
				fileList: [],
			}
		},
		mounted() {
			this.detail()
		},

		methods: {
			submit() {
				if (!this.form.completionDate) {
					vant.Dialog.alert({
						message: '请输入演练完成日期',
					})
					return;
				}
				if (!this.form.issueDescription) {
					vant.Dialog.alert({
						message: '请输入发现问题',
					})
					return;
				}
				if (!this.form.processDescription) {
					vant.Dialog.alert({
						message: '请输入过程描述',
					})
					return;
				}
				var reqParam = {
					companyId: localStorage.getItem('companyId'),
					drillPhotoList: this.form.filePathList,
					planId: gemhoUtil.getParameter('planId'),
					// planName: this.form.planName,
					processDescription: this.form.processDescription,
					issueDescription: this.form.issueDescription,
					completionDate: this.form.completionDate
				}
				var url = "/api/enterpriseDrills"
			
				http.post(url, reqParam).then((res) => {
					console.log('添加结果', res)
					vant.Toast({
						message: '操作成功',
					})
					history.back()
				})
			},
			previewFile(){
				// var src = 'emergencydrill/e40eda16-7a86-4a2a-976b-892e17eeed49.pdf'
				// location.href = './pdfViewer.html?pdfSrc='+ src
				console.log(this.previewUrl + '/' + this.form.filePathList[0])
				location.href = this.previewUrl + '/' + this.form.filePathList[0]
			},
			beforeUpload(file) {
				console.log('beforeUpload',file)
				// 在文件上传之前的处理逻辑，例如校验文件大小、文件类型等
				return true; // 返回 true 继续上传，返回 false 中止上传
			},
			afterRead(file) {
				console.log('afterRead',file)
				// 文件读取完成后的处理逻辑
				const formData = new FormData();
				formData.append('file', file.file); // 通过FormData构建要上传的文件数据
				formData.append('modelName', 'emergencydrill');
			
				// 发送HTTP POST请求
				fetch(this.previewUrl + '/api/common/upload', {
						method: 'POST',
						body: formData
					})
					.then(response => {
						if (response.ok) {
							return response.json();
						}
						throw new Error('Network response was not ok.');
					})
					.then(data => {
						console.log(data); // 处理后端返回的数据
						// 可根据后端返回的数据做进一步处理，如显示上传成功信息等
						this.form.filePathList = data.body ? [data.body] : []
					})
					.catch(error => {
						console.error('There has been a problem with your fetch operation:', error);
					});
			},
			showPopup(popupType) {
				if (!this.disabled) {
					this[popupType] = true
				}
			},
			confirm4completionDate(value) {
				console.log('value', value)
				this.form.completionDate = gemhoUtil.formatDate(new Date(value))
				this.showPopup4completionDate = false
			
			},
			 getEnterprisePlansCompanyDetail() {
				
			},
			 // 整改后照片
			transferUrl(hdRectificationPic) {
			  console.log(hdRectificationPic);
			  if (hdRectificationPic) {
				return (
				  axios.defaults.baseURL +
				  "/hd_rectification_pic_to_verify/" +
				  hdRectificationPic.split("\\hd_rectification_pic_to_verify\\")[1]
				);
			  } else {
				return null;
			  }
			},
			detail(){
				http.get('/api/enterpriseDrills', {
					page: 0, // 每次请求增加下一页
					size: 1,
					planId: gemhoUtil.getParameter('planId'),
					companyId: localStorage.getItem('companyId'),
				}).then((res) => {
					this.loading = false; // 加载状态结束
					this.form = res.body.content[0]
					if(this.form.completionStatus===1){
						this.disabled = true
					}else{
						this.disabled = false
					}
					this.form.filePathList = this.form.drillPhotoList || [];
				})
			},
		},
	});
});