/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				planName: '',
				value: '',
				list: [],
				loading: false,
				finished: false,
				page: 0,
				size: 10,
				total: 0
			}
		},
		mounted() {
			this.getList()
		},
		methods: {
			detail(item){
				gemhoUtil.navigatePage('./emergency-detail.html?planId='+item.id)
			},
			resetSearchForm(){
				this.page = 0
				this.size = 20
				this.total = 0
				this.list = []
				this.finished = false;
			},
			onClear(){
				this.resetSearchForm()
				this.getList()
			},
			onSearch(val){
				this.resetSearchForm()
				console.log('search', val)
				this.getList()
			},
			exportFile(item){
				http.downloadFile('/api/dangerJobReport/export',{
					fileType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
					fileName: 'DW-'+ gemhoUtil.getTargetDateYMD().replaceAll('-', '') +'.xlsx'
				}).then((res)=>{
					vant.Toast({
						message: '操作成功',
					})
					this.loading = false; // 加载状态结束
				})
			},
			add(){
				gemhoUtil.navigatePage('./dw-list-detail.html?type=add')
			},
			edit(item){
				gemhoUtil.navigatePage('./dw-list-detail.html?dwId='+item.id+'&type=edit')
			},
			getList(){
				if(this.loading){
					return
				}
				this.loading = true
				http2.post({
					serviceId: API_KEY_MAP["dw-list"]['id'],
					interfacePublicKey: API_KEY_MAP["dw-list"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["dw-list"]["privateKey"],
					reqParams: {
						page: this.page++,// 每次请求增加下一页
						size: this.size,
						sort: 'id,desc',
					}
				}, (res) => {
						
					if(res){
						console.log('接口回调数据', JSON.parse(res))
						
						var result = JSON.parse(res)
						this.loading = false; // 加载状态结束
						this.list.push(...result.content);
						this.total = result.totalElements
						
						if(this.page*this.size >= this.total){
							 this.finished = true; // 下滑不在刷新数据
						}
						
						
					}
					this.loading = false
				})
				// http.get('/api/enterpriseDrillPlans/company',{
				// 	page: this.page++,// 每次请求增加下一页
				// 	size: this.size,
				// 	planName: this.planName,
				// 	companyId: localStorage.getItem('companyId'),
				// }).then((res)=>{
					
				// 	this.loading = false; // 加载状态结束
				// 	this.list.push(...res.body.content);
				// 	this.total = res.body.totalElements
					
				// 	if(this.page*this.size >= this.total){
				// 		 this.finished = true; // 下滑不在刷新数据
				// 	}
				// })
				
			}
		},
	});
});