/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				value: '',
				list: [],
				loading: false,
				finished: false,
				page: 0,
				size: 10,
				total: 0
			}
		},
		mounted() {
			this.getList()
		},
		methods: {
			detail(item){
				gemhoUtil.navigatePage('./yh-list-detail.html?hdId='+item.hdId+'&type=detail')
			},
			edit(item){
				gemhoUtil.navigatePage('./yh-list-detail.html?hdId='+item.hdId+'&type=edit')
			},
			getList(){
				if(this.loading){
					return
				}
				this.loading = true
				http2.post({
					serviceId: API_KEY_MAP["yh-list"]['id'],
					interfacePublicKey: API_KEY_MAP["yh-list"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["yh-list"]["privateKey"],
					reqParams: {
						page: this.page++,// 每次请求增加下一页
						size: this.size,
						// companyId: localStorage.getItem('companyId'),
						// county: localStorage.getItem('appCounty'),
						sort: 'hdId,desc',
					}
				}, (res) => {
						
					if(res){
						console.log('接口回调数据', JSON.parse(res))
						
						var result = JSON.parse(res)
						this.loading = false; // 加载状态结束
						this.list.push(...result.content);
						this.total = result.totalElements
						
						if(this.page*this.size >= this.total){
							 this.finished = true; // 下滑不在刷新数据
						}
						this.loading = false
					}
				})
				// http2.get('/api/thHiddenDanger',{
				// 	page: this.page++,// 每次请求增加下一页
				// 	size: this.size,
				// 	companyId: localStorage.getItem('companyId'),
				// 	county: localStorage.getItem('appCounty'),
				// 	sort: 'hdId,desc',
				// }).then((res)=>{
					
				// 	this.loading = false; // 加载状态结束
				// 	this.list.push(...res.content);
				// 	this.total = res.totalElements
					
				// 	if(this.page*this.size >= this.total){
				// 		 this.finished = true; // 下滑不在刷新数据
				// 	}
				// })
				
			}
		},
	});
});