/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				noticeContent: '',
				disabled: false,
			}
		},
		mounted() {
			this.detail()
		},

		methods: {
			detail() {
				vant.Toast.loading({
					message: '加载中...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["notice-list-detail"]['id'],
					interfacePublicKey: API_KEY_MAP["notice-list-detail"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["notice-list-detail"]["privateKey"],
					reqParams: {
						noticeId: gemhoUtil.getParameter('noticeId')
					}
				}, (res) => {
					if(!res){ // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.detail()
						}, 0);
						return
					}	
					if(res){
						console.log('接口回调数据', JSON.parse(res))
						
						var result = JSON.parse(res)
						this.noticeContent = result.noticeContent
					}
					setTimeout(() => {
						this.$nextTick(()=>{
							vant.Toast.clear()
						})
					}, 0);
				})
			},
			
		},
	});
});