var VUE = null
window.addEventListener('load', function () {
  
  // 在原有Vue实例中添加
  VUE = new Vue({
    el: '#app',
    data() {
      return {
        flag: 'XQ',
        canvasReady: false,
        loadedImages: 0, // 记录已加载的图片数量
        formData: {
          id: '',
          unitName: '',
          businessAddress: '',
          smallPlaceTypeId: 0,
          useNature: '',
          unifiedSocialCreditCode: '',
          area: '',
          employeeCount: 0,
          owner: '',
          merchantPhone: '',
          qrCodeUrl: '',
          community: '',
          street: '',
          gridMemberName: '',
          gridMemberPhone: '',
          createBy: '',
          createTime: null,
          updateBy: '',
          updateTime: '',
          remark: '',
          deptId: '',
          merchantId: 0,
          smallPlaceType: '',
          smallPlaceTypeName: '',
          principal: '',
          phone: '',
          area: '',
          businessHours: '',
          type: '', // 新增类型字段
        },
        showTypePicker: false,
        typeOptions: ['小餐饮', '酒店', '商场', '学校', '医疗机构'],
      }
    },
    computed: {},
    mounted() {
        this.detail()
    },
    methods: {
      detail(id) {
		  vant.Toast.loading({
		  	message: '正在加载...',
		  	forbidClick: true,
		  	loadingType: 'spinner',
		  });
		  http2.post({
		  	serviceId: API_KEY_MAP["no-page"]['id'],
		  	interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
		  	interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
		  	reqParams: {
				 sign: 11,
		  		"merId": gemhoUtil.getParameter('merId'),
		  	}
		  }, (res) => {
		  	if (!res) { // 中台返回为undefined 重新请求
		  		vant.Toast.clear()
		  		setTimeout(() => {
		  			this.detail()
		  		}, 0);
		  		return
		  	}
		  	if (res) {
		  		console.log('接口回调数据', JSON.parse(res))
		  		setTimeout(() => {
		  			this.$nextTick(() => {
		  				vant.Toast.clear()
		  			})
		  		}, 0);
		  		var result = JSON.parse(res)
		  		this.formData = result.data
				
				// this.formData = {}  // 表单赋值
				// 这里添加跳转逻辑
				const QR_IMAGE_URL = result.data.qrCodeUrl
				this.qrCodeUrl = result.data.qrCodeUrl
				
		  	}
		  })
      
      },
      // 新增选择确认方法
      // onConfirmType(value) {
      //   this.formData.type = value
      //   this.showTypePicker = false
      // },
    },
  })
})

   function saveCanvas() {
	vant.Toast.loading({
		message: '图片保存中...',
		forbidClick: true,
		loadingType: 'spinner',
	});
	
	lightAppJssdk.media.savePhoto({
	  arg: VUE.formData.qrCodeUrl,
	  success: function (data) {
		// vant.Toast.clear()
		// alert(JSON.stringify(data))
		// vant.Dialog.alert({
		// 	message: '保存成功',
		// })
		vant.Toast('保存成功');
	  },
	  fail: function (data) {
		// vant.Toast.clear()
		// alert('保存失败')
		// vant.Dialog.alert({
		// 	message: '保存失败',
		// })
		vant.Toast('保存失败');
	  },
	})
  }


