/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				planName: '',
				list: [],
				loading: false,
				finished: false,
				page: 0,
				size: 9999,
				total: 0
			}
		},
		mounted() {
			this.getList()
		},
		methods: {
			detail(item) {
				gemhoUtil.navigatePage('./emergency-detail.html?planId=' + item.id)
			},
			resetSearchForm() {
				this.page = 0
				this.size = 9999
				this.total = 0
				this.list = []
				this.finished = false;
			},
			onClear() {
				this.resetSearchForm()
				this.getList()
			},
			onSearch(val) {
				this.resetSearchForm()
				console.log('search', val)
				this.getList()
			},
			getList() {
				setTimeout(() => {
					http2.post({
						serviceId: API_KEY_MAP["emergency"]['id'],
						interfacePublicKey: API_KEY_MAP["emergency"][
							"publicKey"
						],
						interfacePrivateKey: API_KEY_MAP["emergency"][
							"privateKey"
						],
						reqParams: {
							page: this.page++, // 每次请求增加下一页
							size: this.size,
							planName: this.planName,
						}
					}, (res) => {

						if (res) {
							// console.log('接口回调数据', JSON.parse(res))

							var result = JSON.parse(res).body
							this.loading = false; // 加载状态结束
							this.list.push(...result.content);
							this.total = result.totalElements

							if (this.page * this.size >= this.total) {
								this.finished = true; // 下滑不在刷新数据
							}
						}
						this.loading = false
						this.$nextTick(()=>{
							// 滚动条跳转位置
							window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'));
						})
					})
				}, 0)
			}
		},
	});
});