/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				list: [],
				loading: false,
				finished: false,
				page: 0,
				size: 9999,
				total: 0
			}
		},
		mounted() {
			this.getList()
		
		
		},
		methods: {
			detail(index) {
				// location.href = './notice-list-detail.html?noticeId='+this.list[index].noticeId
				gemhoUtil.navigatePage('./notice-list-detail.html?noticeId=' + this.list[index]
					.noticeId)
			},
			getList() {
				setTimeout(() => {
					http2.post({
						serviceId: API_KEY_MAP["notice-list"]['id'],
						interfacePublicKey: API_KEY_MAP["notice-list"]["publicKey"],
						interfacePrivateKey: API_KEY_MAP["notice-list"]["privateKey"],
						reqParams: {
							page: this.page++, // 每次请求增加下一页
							size: this.size,
							// sort: 'noticeId,desc',
						}
					}, (res) => {

						if (res) {
							// console.log('接口回调数据', JSON.parse(res))

							var result = JSON.parse(res)
							this.loading = false; // 加载状态结束
							this.list.push(...result.content);
							this.total = result.totalElements

							if (this.page * this.size >= this.total) {
								this.finished = true; // 下滑不在刷新数据
							}
						}
						this.loading = false
						this.$nextTick(()=>{
							// 滚动条跳转位置
							window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'));
						})
					})
				}, 0)
			}
		},
	});
});