/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				form: {
					hdId: '',
					// 检查日期
					hdInspectDate: '',//2024-03-08 00:00:00',
					// 检查人员
					hdInspectExpert: '',//'发发发',
					// 隐患类型
					hdLevel: '1',
					
					type: '',// 安全类别
					category: '',// 安全检查类别,
					inspectionContent: '',//'安全检查内容',
					hdName: '',// 发现问题
					comment: '',//"隐患描述",
					basis: '',//'测试依据',// 检查依据
					suggestion: '',//'测试建议',// 整改建议
					recDeadLine:'', // 整改期限
					hdPic: null,	// 隐患图片
					hdRectificationPic: null,// 隐患整改图片
					// 整改图片文件路径
					rectFilePath: '',
					// 审核人
					hdAcceptancePerson: "",
					hdRectificationRecord: '',
					hdStatus: 0, // 整改中
				},
				// 企业id
				disabled: true,

				fileList: [],
			}
		},
		mounted() {
			if(gemhoUtil.getParameter('type') === 'detail'){
				this.disabled = true
			}else if(gemhoUtil.getParameter('type') === 'edit'){
				this.disabled = false
			}
			this.detail()
		},
		computed:{
			hdLevelText(){
				return this.form.hdLevel===1 ? '一般隐患' : '重大隐患'
			}
		},
		methods: {
			detail(){
				vant.Toast.loading({
					message: '加载中...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				
				http2.post({
					serviceId: API_KEY_MAP["yh-list"]['id'],
					interfacePublicKey: API_KEY_MAP["yh-list"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["yh-list"]["privateKey"],
					reqParams: {
						page: 0,// 每次请求增加下一页
						size: 1,
						hdId: gemhoUtil.getParameter('hdId'),
						sort: 'hdId,desc',
					}
				}, (res) => {
						
					if(res){
						// console.log('接口回调数据', JSON.parse(res))
						
						var result = JSON.parse(res)
						this.loading = false; // 加载状态结束
						
						// console.log('响应结果', result.content)
						this.form = result.content[0]
						if(this.form.hdPic && this.form.hdPic.length){
							this.form.hdPic = this.form.hdPic[0]
						}
						// 整改图片编辑 上传组件图片赋值
						if(this.form.hdRectificationPic && this.form.hdRectificationPic.length && !this.disabled){
							this.fileList.push({
								content: 'data:image/jpg;base64,' + this.form.hdRectificationPic[0]
							})
						}
						
						// 隐患状态 成功和待验证 则不允许编辑
						this.disabled = this.form.hdStatus === 1 || this.form.hdStatus === 3 
						vant.Toast.clear()
					}
				})
			},
			submit() {
				if (!this.fileList.length) {
					vant.Dialog.alert({
						message: '没有整改照片',
					})
					return
				}
				vant.Toast.loading({
					message: '正在处理...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["yh-list-detail"]['id'],
					interfacePublicKey: API_KEY_MAP["yh-list-detail"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["yh-list-detail"]["privateKey"],
					reqParams: {
						hdId: this.form.hdId,
					},
					fileList: [{
						fileName: 'hdRectificationPic',
						file: this.fileList[0].file
					}]
				}, (res) => {
						
					if(res){
						// console.log('接口回调数据', JSON.parse(res))
						
						var result = JSON.parse(res)
						this.loading = false; // 加载状态结束
						
						// console.log('响应结果', result)
					
						// vant.Toast.clear()
						// vant.Toast({
						// 	message: '操作完成',
						// })
						// location.href="./yh-list.html"
						gemhoUtil.navigatePage('./yh-list.html', '操作完成,页面跳转中...')
					
					}
				})
			},
		},
	});
});