/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				loadFlag: false,
				value: '',
				list: [],
				// loadFlag: false,
				finished: false,
				page: 0,
				size: 9999,
				total: 0
			}
		},
		mounted() {
			this.getList()
		},
		methods: {
			detail(item) {
				gemhoUtil.navigatePage('./yh-list-detail.html?hdId=' + item.hdId + '&type=detail')
			},
			edit(item) {
				gemhoUtil.navigatePage('./yh-list-detail.html?hdId=' + item.hdId + '&type=edit')
			},
			getList() {
				setTimeout(() => {
					http2.post({
						serviceId: API_KEY_MAP["yh-list"]['id'],
						interfacePublicKey: API_KEY_MAP["yh-list"]["publicKey"],
						interfacePrivateKey: API_KEY_MAP["yh-list"]["privateKey"],
						reqParams: {
							page: this.page++, // 每次请求增加下一页
							size: this.size,
							sort: 'hdId,desc',
						}
					}, (res) => {
						if (res) {
							var result = JSON.parse(res)
							this.list.push(...result.content);
							this.total = result.totalElements

							if (this.page * this.size >= this.total) {
								this.finished = true; // 下滑不在刷新数据
							}
						}
						this.loadFlag = false
						// console.log('响应结束',this.total, this.list.length)
						this.$nextTick(()=>{
							// 滚动条跳转位置
							window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'));
						})
					})
				}, 0)

			}
		},
	});
});