/** axios封装
 * 请求拦截、相应拦截、错误统一处理
 */
// 环境的切换

if (window.env == 'dev') {
	axios.defaults.baseURL = 'http://192.168.2.37:8080'
	// 商户token
	// axios.defaults.headers.common['Authorization'] =
	//   'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiLlvKDlrZ3lvakiLCJsb2dpbl91c2VyX2tleSI6IjNjMmRiMWFiLWIyZGMtNDBjYi04YjM5LWRiNTJmM2VmYzNkYyJ9.sfZyPP-COShNCjwxKR26zGDsPHXss97gu7JEpaMapIZyMQEsxzMigVickcqdhaqDwTRcfr0IxAj64vnrriS9Cw'
	
	// admin账号token
	axios.defaults.headers.common['Authorization'] =
	'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJhZG1pbiIsImxvZ2luX3VzZXJfa2V5IjoiYjA1MWRmZmEtYWE4Yy00NTNiLThlNGUtMTdjOTEzYmMwOWFkIn0.nj2miSFFPQRDabzhq_05z_wW0w13quXBooQbbtnyRZQxOhxenEQQZM3OgKjgd8AxjY7W2uKlpdyqGuTmMb1PRQ'
	
}else{
	axios.defaults.baseURL = 'https://gqyjpt.weihai.cn/prod-api'
	axios.defaults.headers.common['Authorization'] = gemhoUtil.getCookie('token')
}


axios.defaults.timeout = 50000
// post请求头
// axios.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8'
axios.defaults.headers.post['Content-Type'] = 'application/json'


// 请求拦截器

axios.interceptors.request.use((config) => {
  vant.Toast.loading({
    message: '加载中...',
    forbidClick: true,
    loadingType: 'spinner',
  })
  return config
})

// 响应拦截器
axios.interceptors.response.use(
  (res) => {
    // 成功的响应数据  服务器的相关的数据返回来之后，响应拦截器能够检测到，可以做一些事

    vant.Toast.clear()
    return res
  },
  (error) => {
    // 响应失败的时候的回调函数
    return Promise.reject(new Error(error))
  }
)

var http3 = {
 	get: function(url, params) {
 		return new Promise((resolve, reject) => {
 			axios
 				.get(url, {
 					params: params
 				})
 				.then(res => {
 					resolve(res.data)
 				})
 				.catch(err => {
 					reject(err.data)
 				})
 		})
 	},
 	post: function(url, params) {
 		return new Promise((resolve, reject) => {
 			axios
 				.post(url, params)
 				.then(res => {
 					let response = res.data
 					console.log('res.statusCode', response)
 					if (response.statusCode >= 300 || response.status >= 300) {
 						// alert('系统发生错误')
 						vant.Dialog.alert({
 							title: '信息提示',
 							message: response.message,
 						})
 						return
 					}
 					resolve(res.data)
 				})
 				.catch(err => {
 					reject(err.data)
 				})
 		})
 	},
 	delete: function(url, params) {
 		return new Promise((resolve, reject) => {
 			axios({
 					url,
 					method: 'post',
 					data: params,
 					headers: {
 						// 'Content-Type': 'application/json', // 'multipart/form-data;',
 						'Authorization': localStorage.getItem('Authorization'),
 						'requestType': 'delete'
 
 					},
 				})
 				.then(res => {
 					let response = res.data
 					console.log('res.statusCode', response)
 					if (response.statusCode >= 300 || response.status >= 300) {
 						// alert('系统发生错误')
 						vant.Dialog.alert({
 							title: '信息提示',
 							message: response.message,
 						})
 						return
 					}
 					resolve(res.data)
 				})
 				.catch(err => {
 					reject(err.data)
 				})
 		})
 	},
 	put: function(url, params) {
 		return new Promise((resolve, reject) => {
 			axios({
 					url,
 					method: 'post',
 					data: params,
 					headers: {
 						// 'Content-Type': 'application/json', // 'multipart/form-data;',
 						'Authorization': localStorage.getItem('Authorization'),
 						'requestType': 'put'
 
 					},
 				})
 				.then(res => {
 					let response = res.data
 					console.log('res.statusCode', response)
 					if (response.statusCode >= 300 || response.status >= 300) {
 						// alert('系统发生错误')
 						vant.Dialog.alert({
 							title: '信息提示',
 							message: response.message,
 						})
 						return
 					}
 					resolve(res.data)
 				})
 				.catch(err => {
 					reject(err.data)
 				})
 		})
 	},
 	postFile: function(url, params) {
 		return new Promise((resolve, reject) => {
 			axios({
 					url,
 					method: 'post',
 					data: params,
 					headers: {
 						'Content-Type': 'application/json', // 'multipart/form-data;',
 						'Authorization': localStorage.getItem('Authorization')
 					},
 				}).then(res => {
 					let response = res.data
 					console.log('res.statusCode', response)
 					if (response.statusCode >= 300 || response.status >= 300) {
 						// alert('系统发生错误')
 						vant.Dialog.alert({
 							title: '信息提示',
 							message: response.message,
 						})
 						return
 					}
 					resolve(res.data)
 				})
 				.catch(err => {
 					reject(err.data)
 				})
 		})
 	},
 	downloadFile: function(url, params) {
 		console.log('downloadfILE', params)
 		return new Promise((resolve, reject) => {
 			axios({
 					url,
 					method: 'get',
 					// data: params,
 					params: params,
 					headers: {
 						// 'Content-Type': 'application/json', // 'multipart/form-data;',
 						'Authorization': localStorage.getItem('Authorization')
 					},
 					responseType: 'blob' //在请求中加上这一行，特别重要
 				}).then(res => {
 					// 返回格式是文件流格式
 					// 在请求拿到文件流res以后，使用a标签下载
 					let fileData = res.data
 					let blob = new Blob([fileData], {
 							type: 'application/msword;charset=UTF-8'
 						}
 						/* , {
 										    type: `application/vnd.openxmlformats-officedocument.wordprocessingml.document;charset=utf-8;`
 										  } */
 					)
 
 					var a = document.createElement('a');
 					document.body.appendChild(a);
 					a.style = 'display: none';
 					var url = window.URL.createObjectURL(blob);
 					a.href = url;
 					a.setAttribute('download', 'YH-' + gemhoUtil.getTargetDateYMD().replaceAll('-',
 						'') + '.docx')
 					a.click();
 					a.remove();
 					window.URL.revokeObjectURL(url);
 				})
 				.catch(err => {
 					reject(err.data)
 				})
 		})
 	},
 }