/**
 * author: dabao
 * date: 2024-03-15
 * description: 商户首页
 */
var VUE = null
window.addEventListener("load", function () {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				// 新增子Tab数据
				subActiveTab: 0,
				hazardList: [// 更多示例数据...
				],
				activeTab: 0,
				showTimePicker: false,
				// 新增以下数据
				showTypePicker: false,
				typeOptions: ['小餐饮', '酒店', '商场', '学校', '医疗机构'],
				formData: {
					principal: '',
					phone: '',
					area: '',
					businessHours: '',
					type: '', // 新增类型字段
				},
				checkList: [{
					id: 1,
					date: '2024-03-15',
					result: '合格'
				},
				{
					id: 2,
					date: '2024-03-14',
					result: '不合格'
				}
				],
				merId: '',
				merInformation: { // 新增商户信息对象

				},
				jcLisk: [{ // 新增检查列表数据
				}],
				UserPermission: false, // 用户是否具有安全检查权限
			}
		},
		created() {
			let params = gemhoUtil.getUrlParams()
			console.log(params);
			this.merId = params.merId
		},
		mounted() {
			this.getShopInfo() // 获取商户信息
			this.getShopDate() // 获取商户统计信息
			this.getYhList() // 获取隐患记录
			// this.getJcList() // 获取检查列表
			this.getUserPermission()//获取用户是否具有安全检查资格
		},
		computed: {
			filteredHazards() {
				const statusMap = ['全部', '待审核', '待整改', '已整改', '整改逾期'];
				return this.hazardList.filter(item =>
					this.subActiveTab === 0 ? true : item.rectificationStatusName === statusMap[this.subActiveTab]
				);
			}
		},
		methods: {
			navTo(url) {
				// gemhoUtil.nav2asd(url)
				let params = gemhoUtil.getUrlParams()
				if (url == 'check_info') {
					params = {
						...params,
						flag: 'ADD',
						pageName: '_shanghu_home'
					}
				}
				let strurl = gemhoUtil.setParameter(`_${url}.html`, params)
				gemhoUtil.navigatePage(strurl, '跳转中...')
			},
			clickTab() {
				if (this.activeTab > 0) {
					this.getJcList() // 获取检查列表
				}

			},
			// 新增选择确认方法
			onConfirmType(value) {
				this.formData.type = value;
				this.showTypePicker = false;
			},
			onConfirmTime(time) {
				this.formData.businessHours = time;
				this.showTimePicker = false;
			},
			statusTagType(status) {
				const types = {
					'待审核': 'warning',
					'待整改': 'primary',
					'已整改': 'success',
					'整改逾期': 'danger',
				};
				return types[status] || '';
			},
			viewDetail(item, type) {
				let params = {
					id: item.id,
					merId: this.merId,
					pageName: '_shanghu_home'
				}
				// 这里添加跳转逻辑
				if (type === 'YH_XQ') {
					params = {
						...params,
						flag: item.rectificationStatus,
					}
				} else {
					params = {
						...params,
						flag: 'JC_XQ',
					}
				}
				let url = gemhoUtil.setParameter('_check_info.html', params)
				gemhoUtil.navigatePage(url, '跳转中...')
			},
			//获取商户统计信息
			getShopDate() {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				})
				setTimeout(() => {
					http2.post(
						{
							serviceId: API_KEY_MAP['no-page']['id'],
							interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
							reqParams: {
								sign: 6,
								pageNum: this.page++, // 每次请求增加下一页
								pageSize: this.size,
								merId: this.merId,
								sort: 'lawId,desc',
							},
						},
						(res) => {
							if (!res) {
								// 中台返回为undefined 重新请求
								vant.Toast.clear()
								this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
								setTimeout(() => {
									// this.getList()
								}, 0)
								return
							}
							if (res) {
								var result = JSON.parse(res)
								this.merInformation = { ...this.merInformation, ...result.data }
							}
						}
					)
				}, 0)
			},
			//获取商户信息
			getShopInfo() {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				})
				setTimeout(() => {
					http2.post(
						{
							serviceId: API_KEY_MAP['no-page']['id'],
							interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
							reqParams: {
								sign: 11,
								pageNum: this.page++, // 每次请求增加下一页
								pageSize: this.size,
								merId: this.merId,
								sort: 'lawId,desc',
							},
						},
						(res) => {
							if (!res) {
								// 中台返回为undefined 重新请求
								vant.Toast.clear()
								this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
								setTimeout(() => {
									// this.getList()
								}, 0)
								return
							}
							if (res) {
								var result = JSON.parse(res)
								this.merInformation = { ...this.merInformation, ...result.data }
							}
						}
					)
				}, 0)
			},
			//获取隐患记录
			getYhList() {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				})
				setTimeout(() => {
					http2.post(
						{
							serviceId: API_KEY_MAP['page']['id'],
							interfacePublicKey: API_KEY_MAP['page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
							reqParams: {
								sign: 3,
								merId: this.merId,
								status: '',
								pageNum: this.page++, // 每次请求增加下一页
								pageSize: this.size,
								sort: 'lawId,desc',
							},
						},
						(res) => {
							if (!res) {
								// 中台返回为undefined 重新请求
								vant.Toast.clear()
								this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
								setTimeout(() => {
									// this.getList()
								}, 0)
								return
							}
							if (res) {
								var result = JSON.parse(res)
								this.hazardList = result.rows
								console.log(result)
							}
						}
					)
				}, 0)
			},
			//获取检查列表
			getJcList() {
				// 更多示例数据...
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				})
				setTimeout(() => {
					http2.post(
						{
							serviceId: API_KEY_MAP['page']['id'],
							interfacePublicKey: API_KEY_MAP['page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
							reqParams: {
								sign: 1,
								type: this.activeTab,
								merId: this.merId,
								pageNum: this.page++, // 每次请求增加下一页
								pageSize: this.size,
								sort: 'lawId,desc',
							},
						},
						(res) => {
							if (!res) {
								// 中台返回为undefined 重新请求
								vant.Toast.clear()
								this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
								setTimeout(() => {
									// this.getList()
								}, 0)
								return
							}
							if (res) {
								var result = JSON.parse(res)
								if (result.code !== 200 && result.data == null) {
									return
								}
								this.jcLisk = result.rows
								if (this.page * this.size >= this.total) {
									this.finished = true // 下滑不在刷新数据
								}
							}
							this.loading = false
							setTimeout(() => {
								this.$nextTick(() => {
									vant.Toast.clear()
								})
							}, 0)
							this.$nextTick(() => {
								// 滚动条跳转位置
								window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'))
							})
						}
					)
				}, 0)
			},
			//获取用户是否有安全检查的权限
			getUserPermission() {
				setTimeout(() => {
					http2.post(
						{
							serviceId: API_KEY_MAP['no-page']['id'],
							interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
							reqParams: {
								sign: 13,
								merId: this.merId,
								pageNum: this.page++, // 每次请求增加下一页
								pageSize: this.size,
								sort: 'lawId,desc',
							},
						},
						(res) => {
							if (!res) {
								// 中台返回为undefined 重新请求
								vant.Toast.clear()
								this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
								setTimeout(() => {
									// this.getList()
								}, 0)
								return
							}
							if (res) {
								var result = JSON.parse(res)
								if (result.code !== 200 && result.data == null) {
									return
								}
								console.log(result.data, result, '获取用户是否具有安全检查资格');
								this.UserPermission = result.data.length > 0 ? true : false
								if (this.page * this.size >= this.total) {
									this.finished = true // 下滑不在刷新数据
								}
							}
							this.loading = false
							setTimeout(() => {
								this.$nextTick(() => {
									vant.Toast.clear()
								})
							}, 0)
							this.$nextTick(() => {
								// 滚动条跳转位置
								window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'))
							})
						}
					)
				}, 0)
			}

		}
	});

})