var VUE = null
window.addEventListener('load', function () {
  VUE = new Vue({
    el: '#app',
    data() {
      return {
		  merName: '',
        // 新增子Tab数据
        activeTab: '1',
        hazardList: [
          {
            id: 1,
            merchantName: '福源便利店',         // 商户名称
            smallPlaceTypeName: '零售店铺',      // 场所类型
            checkUnit: '高区消防救援大队',       // 检查单位
            checkPeopleName: '王建军',           // 监察人
            checkDate: '2024-07-12',             // 检查日期
            notRectifiedCount: 3,                // 未整改数
            hiddenCount: 7                       // 隐患数
          },
          {
            id: 2,
            merchantName: '美味家火锅店',
            smallPlaceTypeName: '餐饮场所',
            checkUnit: '高区市场监督管理局',
            checkPeopleName: '李雪晴',
            checkDate: '2024-07-14',
            notRectifiedCount: 0,
            hiddenCount: 2
          },
          {
            id: 3,
            merchantName: '阳光网吧',
            smallPlaceTypeName: '娱乐场所',
            checkUnit: '高区应急管理局',
            checkPeopleName: '张卫国',
            checkDate: '2024-07-15',
            notRectifiedCount: 1,
            hiddenCount: 5
          },
          {
            id: 4,
            merchantName: '康旭药店',
            smallPlaceTypeName: '医疗场所',
            checkUnit: '高区消防救援大队',
            checkPeopleName: '陈雨桐',
            checkDate: '2024-07-16',
            notRectifiedCount: 4,
            hiddenCount: 9
          }
        ],
        // 新增以下数据
        userInfo: {},
        userData: {
          checkCount: 0, //检查数
          checkSelfCount: 0, //自查数
          hiddenCount: 0, //隐患数
          hiddenNoReCount: 0, //未整改数
        },
        page: 1,
        size: 10,
        merId: null, // 商户id
        unitName: '', // 单位名称
        smallPlaceTypeName: '', // 场所类型
      }
    },
    created() {
      let urlParams = gemhoUtil.getUrlParams()
      this.merId = urlParams.merId
      this.unitName = urlParams.unitName
      this.smallPlaceTypeName = urlParams.smallPlaceTypeName
      this.init()
    },
    computed: {},
    methods: {
		reset(){
			this.page = 1
			this.size = 10
			this.hazardList = []
		},
		onSearch() {
		  console.log('xxxx', this.merName)
		  this.reset()
		  this.getMerchantSelfCheckData()
		},
      //初始化页面
      init() {
        // this.getMerchantSelfCheckData()
      },
	  tabChange(){
		   this.reset()
		   this.getMerchantSelfCheckData()
	  },
      getMerchantSelfCheckData() {
        // 更多示例数据...
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
        setTimeout(() => {
          http2.post(
            {
              serviceId: API_KEY_MAP['page']['id'],
              interfacePublicKey: API_KEY_MAP['page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
              reqParams: {
                sign: 1,
                type: this.activeTab,
                merId: this.merId,
                pageNum: this.page++, // 每次请求增加下一页
                pageSize: this.size,
                sort: 'lawId,desc',
				merName: this.merName,
				
              },
            },
            (res) => {
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  this.getMerchantSelfCheckData()
                }, 0)
                return
              }
              if (res) {
                var result = JSON.parse(res)
                if (result.code !== 200 && result.data == null) {
                  return
                }
                this.hazardList.push(...result.rows)
                if (this.page * this.size >= this.total) {
                  this.finished = true // 下滑不在刷新数据
                }
              }
              this.loading = false
              setTimeout(() => {
                this.$nextTick(() => {
                  vant.Toast.clear()
                })
              }, 0)
              this.$nextTick(() => {
                // 滚动条跳转位置
                window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'))
              })
            }
          )
        }, 0)
      },
      viewDetail(id) {
        let urlParams = gemhoUtil.getUrlParams()
        let param = {
          ...urlParams,
          id: id,
          flag: 'JC_XQ',
          pageName: '_checkrecord-all',
        }
        let url = gemhoUtil.setParameter('_check_info.html', param)

        gemhoUtil.navigatePage(url, '跳转中...')
        // 这里添加跳转逻辑
      },
    },
  })
})
