var VUE = null
window.addEventListener('load', function () {

	// 在原有Vue实例中添加
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				formData: {
				},
			}
		},
		computed: {},
		mounted() {
			this.detail()
		},
		methods: {
			detail() {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["no-page"]['id'],
					interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
					reqParams: {
						sign: 19,
						"feedbackId": gemhoUtil.getParameter('id'),
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.detail()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据=建议详情', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.formData = result.data
					}
				})
			},
			showImage(list, index) {
				vant.ImagePreview({
					images: list,
					startPosition: index,
					closeable: true,
				});
			},
		},
	})
})

