var VUE = null
window.addEventListener('load', function () {

	// 在原有Vue实例中添加
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				loading: false,
				finished: false,
				page: 0,
				size: 9999,
				total: 0,
				
				activeTab: 0,
				flag: 'XQ',
				canvasReady: false,
				loadedImages: 0, // 记录已加载的图片数量
				userType: gemhoUtil.getCookie('userType'),
				formData: {
					id: '',
					unitName: '',
					businessAddress: '',
					smallPlaceTypeId: 0,
					useNature: '',
					unifiedSocialCreditCode: '',
					area: '',
					employeeCount: 0,
					owner: '',
					merchantPhone: '',
					qrCodeUrl: '',
					community: '',
					street: '',
					gridMemberName: '',
					gridMemberPhone: '',
					createBy: '',
					createTime: null,
					updateBy: '',
					updateTime: '',
					remark: '',
					deptId: '',
					merchantId: 0,
					smallPlaceType: '1',
					smallPlaceTypeName: '',
					principal: '',
					phone: '',
					area: '',
					businessHours: '',
					type: '', // 新增类型字段
					photos: [
						{
							"file": {},
							"status": "",
							"message": "",
							"content": "data:image/jpeg;base64,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"
						}
					], // 新增图片数组字段
				},
				dict4changhsuoType: [],
				dict4fangwuType: [],
				dict4fangwuyongtuType: [],
				dict4businessType: [],
				dict4community: [],
				dict4industryType: [],
				consumerSuggestList: []
			}
		},
		computed: {},
		mounted() {
			// 详情编辑权限控制
			const userType = gemhoUtil.getCookie('userType')
			if (userType !== 'wgy') {
				this.flag = 'XG'
			} else {
				this.flag = 'XQ'
			}

			this.detail()
			this.getDict4fangwuType()
			this.getDict4fangwuyongtuType()
			this.getDict4businessType()
			this.getDict4community()
			this.getDict4industryType()
			// this.getDict4changhsuoType()
		},
		watch: {
			'formData.industryType': {
				handler(newVal) {
					// 选择后晴空下级下拉框值
					this.dict4changhsuoType = []
					
					this.getDict4changhsuoType({
						industryId: newVal
					})
				},
				deep: true // 深度监听对象属性
			}
		},
		methods: {
			viewDetail(item) {
				let params = {
					id: item.id,
				}
				// 这里添加跳转逻辑

				let url = gemhoUtil.setParameter('_consumer_jydetail.html', params)
				gemhoUtil.navigatePage(url, '跳转中...')
			},
			clickTab() {
				if (this.activeTab > 1) {
					this.getConsumerSuggestList() // 获取检查列表
				}
			},
			showImage(list, index) {
				vant.ImagePreview({
					images: list,
					startPosition: index,
					closeable: true,
				});
			},
			getConsumerSuggestList() {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["page"]['id'],
					interfacePublicKey: API_KEY_MAP["page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["page"]["privateKey"],
					reqParams: {
						page: this.page++, // 每次请求增加下一页
						size: this.size,
						sign: 18, // 消费者建议列表
						"merId": gemhoUtil.getParameter('merId'),
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
						setTimeout(() => {
							this.consumerSuggestList()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据-消费者建议', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.consumerSuggestList.push(...result.rows);
						this.total = result.totalElements
						
						if (this.page * this.size >= this.total) {
							this.finished = true; // 下滑不在刷新数据
						}
					}
					this.loading = false
					setTimeout(() => {
						this.$nextTick(()=>{
							vant.Toast.clear()
						})
					}, 0);
				})
			},
			getDict4changhsuoType(param) {
				http2.post({
					serviceId: API_KEY_MAP["page"]['id'],
					interfacePublicKey: API_KEY_MAP["page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["page"]["privateKey"],
					reqParams: {
						page: 1,
						size: 9999,
						sign: 21, // 场所类型=>行业类别
						...param
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDict4changhsuoType()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.dict4changhsuoType = result.data.body.data
						if(!this.dict4businessType.length){ // 如果下拉列表为空，则置空场所类型的值。
							this.formData.smallPlaceTypeId = null
						}

					}
				})
			},
			// handleIndustryChange(val) {
			// 	// 选择后晴空下级下拉框值
			// 	this.dict4changhsuoType = []
			// 	this.getDict4changhsuoType({
			// 		industryId: this.formData.industryType
			// 	})
			// },
			getDict4industryType() {
				http2.post({
					serviceId: API_KEY_MAP["page"]['id'],
					interfacePublicKey: API_KEY_MAP["page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["page"]["privateKey"],
					reqParams: {
						page: 1,
						size: 9999,
						sign: 20, // 行业类型列表
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDict4industryType()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据-行业类型', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.dict4industryType = result.data.body.data

					}
				})
			},
			getDict4community() {
				http2.post({
					serviceId: API_KEY_MAP["page"]['id'],
					interfacePublicKey: API_KEY_MAP["page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["page"]["privateKey"],
					reqParams: {
						page: 1,
						size: 9999,
						sign: 22,
						"merId": gemhoUtil.getParameter('merId'),
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDict4community()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据=所属社区', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.dict4community = result.data

					}
				})
			},
			getDict4businessType() {
				http2.post({
					serviceId: API_KEY_MAP["page"]['id'],
					interfacePublicKey: API_KEY_MAP["page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["page"]["privateKey"],
					reqParams: {
						page: 1,
						size: 9999,
						sign: 15,
						dictType: 'business_type'
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDict4businessType()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据=生产经营类型', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.dict4businessType = result.rows

					}
				})
			},

			getDict4fangwuType() {
				http2.post({
					serviceId: API_KEY_MAP["page"]['id'],
					interfacePublicKey: API_KEY_MAP["page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["page"]["privateKey"],
					reqParams: {
						page: 1,
						size: 9999,
						sign: 15,
						dictType: 'house_type'
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDict4fangwuType()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.dict4fangwuType = result.rows

					}
				})
			},
			getDict4fangwuyongtuType() {
				http2.post({
					serviceId: API_KEY_MAP["page"]['id'],
					interfacePublicKey: API_KEY_MAP["page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["page"]["privateKey"],
					reqParams: {
						page: 1,
						size: 9999,
						sign: 15,
						dictType: 'house_usage'
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDict4fangwuyongtuType()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数=房屋用途', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.dict4fangwuyongtuType = result.rows

					}
				})
			},
			save() {
				vant.Toast.loading({
					message: '正在处理...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				var reqParam = { ...this.formData }			// var url = "/gq/checkRecord/safeCheckRecord"

				if (!reqParam.unitName) {
					vant.Toast({
						message: '商家名称不能为空',
					})
					return
				}
				if (!reqParam.area) {
					vant.Toast({
						message: '建筑面积不能为空',
					})
					return
				}
				if (!reqParam.merchantName) {
					vant.Toast({
						message: '负责人不能为空',
					})
					return
				}
				if (!reqParam.community) {
					vant.Toast({
						message: '所属社区不能为空',
					})
					return
				}

				if (!reqParam.industryType) {
					vant.Toast({
						message: '行业类型不能为空',
					})
					return
				}

				http3.put('/gq/merchant', reqParam).then((res) => {
					console.log('添加结果', res)
					vant.Toast({
						message: '操作成功',
					})
					// gemhoUtil.navigatePage(`${this.pageName}.html${window.location.search}`, '操作完成,跳转中...')
				})
			},
			// 文件上传处理
			handleFileUpload(file) {
				console.log('上传文件:', file);
				// 此处可添加实际文件上传逻辑
			},
			// 场所类型
			handlesmallPlaceTypeNameConfirm(event, item) {
				console.log('select选择', event.target.value)
				const value = event.target.value;
				if (value) {
					const days = parseInt(value);
					item.deadlineDays = days;
					const deadlineDate = new Date();
					deadlineDate.setDate(deadlineDate.getDate() + days);
					item.deadlineDate = this.formatDate(deadlineDate);
				}
				// this.showDeadlinePicker = false;
			},
			saveCanvas() {
				vant.Toast.loading({
					message: '图片保存中...',
					forbidClick: true,
					loadingType: 'spinner',
				});

				lightAppJssdk.media.savePhoto({
					arg: VUE.formData.qrCodeUrl,
					success: function (data) {
						vant.Toast('保存成功');
					},
					fail: function (data) {
						vant.Toast('保存失败');
					},
				})
			},
			detail(id) {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["no-page"]['id'],
					interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
					reqParams: {
						sign: 11,
						"merId": gemhoUtil.getParameter('merId'),
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.detail()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.formData = result.data
						// setTimeout(()=>{
						// 	this.formData.smallPlaceTypeName = "0"
						// },1000)

						// this.formData = {}  // 表单赋值
						// 这里添加跳转逻辑
						const QR_IMAGE_URL = result.data.qrCodeUrl
						this.qrCodeUrl = result.data.qrCodeUrl

					}
				})

			},
			// 新增选择确认方法
			// onConfirmType(value) {
			//   this.formData.type = value
			//   this.showTypePicker = false
			// },
		},
	})
})




