var VUE = null
window.addEventListener('load', function () {
  VUE = new Vue({
    // 在原有Vue实例中添加
    el: '#app',
    data() {
      return {
        shanghuName: '',
        // 新增子Tab数据
        hazardList: [
          // 更多示例数据...
        ],
        activeTab: '',
		status: '',
        merId: '',
        showSearch: false, // 控制搜索框的显示和隐藏
		// 整改状态 0：待整改 1：已整改 2：待审核 3：整改逾期
		tabList: [
          { name: '', title: '全部', msgNum:0, },
          { name: '2', title: '待审核', msgNum:0, },
          { name: '0', title: '待整改', msgNum:5, },
          { name: '1', title: '已整改' , msgNum:6,},
          { name: '3', title: '整改逾期' , msgNum:7,},
        ],
		loading: false,
		finished: false,
		page: 0,
		size: 6,
		total: 0
      }
    },
    computed: {
    },
    created() {
     let merId = gemhoUtil.getParameter('merId')
      if (merId !== undefined && merId !== null) {
        this.merId = merId
      } else {
        this.merId = ''
      }
	  // 2025年6月7日 新增首页（信息统计跳转）类别区分逻辑。
	  let type = gemhoUtil.getParameter('type')
	  if(type === 'nopass'){
		this.activeTab = 2
	  }else if(type === 'willExpire'){ // 即将超期待整改
		this.activeTab = 2
	  }else if(type === 'expired'){ // 超期 整改逾期
		this.activeTab = 4
	  }
      if (gemhoUtil.getCookie('userType') !== 'shop') {
        this.showSearch = true
      }
      this.init()
    },
    methods: {
		reset(){
			this.page = 0
			this.size = 6
			this.hazardList = []
		},
		yhstatus(){ // tab值对应的隐患状态码装欢
			if(this.activeTab === 0){
				return ''
			}else if(this.activeTab === 1){
				return ~~'2'
			}else if(this.activeTab === 2){
				return ~~'0'
			}else if(this.activeTab === 3){
				return ~~'1'
			}else if(this.activeTab === 4){
				return ~~'3'
			}
		},
		tabChange(title){
			console.log('tab 切换', title)
			this.reset()
			this.getList()
		},
      init() {
        this.getList()
      },
      onSearch() {
		  this.reset()
		this.getList()
      },
      // 新增选择确认方法
      onConfirmType(value) {
        this.formData.type = value
        this.showTypePicker = false
      },
      statusTagType(status) {
        const types = {
          待审核: 'warning',
          待整改: 'primary',
          已整改: 'success',
          整改逾期: 'danger',
        }
        return types[status] || ''
      },
      viewDetail(item) {
        let param = {
          id: item.id,
          flag: item.rectificationStatus,
          pageName: '_yh_check',
        }
        let url = gemhoUtil.setParameter('_check_info.html', param)
        console.log(url)

        gemhoUtil.navigatePage(url, '跳转中...')
        // 这里添加跳转逻辑
      },
      //获取隐患列表数据
      getList() {
        // 这里添加获取数据的逻辑
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
        setTimeout(() => {
          http2.post(
            {
              serviceId: API_KEY_MAP['page']['id'],
              interfacePublicKey: API_KEY_MAP['page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
              reqParams: {
				  sign: 3,
				  // merId: this.merId ? this.merId : '',
				  merName: this.shanghuName,
				  pageNum: this.page++, // 每次请求增加下一页
				  pageSize: this.size,
				  sort: 'lawId,desc',
				  status: this.yhstatus()
              },
            },
            (res) => {
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  // this.getList()
                }, 0)
                return
              }
              if (res) {
				var result = JSON.parse(res)
				console.log(result, 'result')
				this.loading = false; // 加载状态结束
				this.hazardList.push(...result.rows);
				this.total = result.total
				
				if (this.page * this.size >= this.total) {
					this.finished = true; // 下滑不在刷新数据
				}
              }
			  this.loading = false
			  setTimeout(() => {
			  	this.$nextTick(()=>{
			  		vant.Toast.clear()
			  	})
			  }, 0);
			  
            }
          )
        }, 0)
      },
    },
  })
})
