/**
 * author: dabao
 * date: 2024-03-15
 * description: 商户首页
 */
var VUE = null
window.addEventListener("load", function () {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				detailInfo:{}
			}
		},
		created() {
		},
		mounted() {
			this.detail()
		},
		methods: {
			handleVideoError(e) {
				const error = e.target.error;
				console.error("视频播放错误:", {
				  code: error.code,
				  message: [
					"未知错误",
					"网络错误（文件不可达）",
					"解码错误（格式/编码不支持）",
					"URL无效"
				  ][error.code - 1]
				});
			  },
			detail(){
				 // 这里添加获取数据的逻辑
				 vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				  })
				  setTimeout(() => {
					http2.post(
					  {
						serviceId: API_KEY_MAP['no-page']['id'],
						interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
						interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
						reqParams: {
						  sign: 17,
						  safetyId: gemhoUtil.getParameter('id'),
						},
					  },
					  (res) => {
						if (res) {
						  var result = JSON.parse(res)
						  this.detailInfo = result.data
						  // this.detailInfo.videoUrl = './test/testVideo.mp4'
						  console.log(result, 'detail result')

						   // 关键新增：视频地址更新后，强制重新加载视频
						   const videoEl = document.getElementById('myVideo');
						   if (videoEl) {
							   videoEl.load(); // 触发浏览器重新加载视频资源
						   }
						   
						   console.log('动态视频地址：', this.detailInfo.videoUrl); // 打印验证地址是否正确
						}
						vant.Toast.clear()
					  }
					)
				  }, 0)
			},
			
		}
	});

})