/**
 * 1：根据商铺id 查询安全检查记录
 * 2：根据记录id 查询详情
 * 	3：隐患列表
	4：隐患详情
	5：查询安全检查模板数据
	6：商家首页按月查询
	9：用户角色可查看的模块
	10：查询用户检查过的商户信息
	11: 查询商户详情信息
	
	跳转逻辑：
	新增检查单，flag=ADD，
	检查单详情，flag=JC_XQ，id=记录id
	待审核隐患，flag=2，id=隐患id
	待整改隐患，flag=0，id=隐患id
	已整改隐患，flag=1，id=隐患id
	整改逾期隐患，flag=3，id=隐患id
	
	
	整改状态 0：待整改 1：已整改 2：待审核 3：整改逾期
	
 */

var VUE = null
// 隐患选择是的时候的编号特殊处理
// const YES_YH_NO = [8, 9, 12, 22, 28, 31, 32, 33, 34, 35]
// split之后 ["8", "9", "12", "14", "22", "23", "28", "34", "35", "36"] 为字符串，需要转化为数字类型。
const YES_YH_NO = gemhoUtil.getCookie('yesItemIds').split(',').map(item => item*1)
// console.log(YES_YH_NO, 'yesno')


window.onload = function () {
	function countSelectedNo(result) {
		// 获取 checkList 中 selected 为 'no' 的对象个数
		return result.reduce((total, category) => {
			return (
				total +
				category.gqCheckItemList.filter((item) => {
					if(YES_YH_NO.includes(item.id)){
						return item.itemAnswer === 1
					}
					return item.itemAnswer === 2
				}).length
					
			)
		}, 0)
	}

	function countSelectedNotNull(result) {
		// 获取 checkList 中 selected 不为 null 的个数
		return result.reduce((total, category) => {
			return (
				total +
				category.gqCheckItemList.filter((item) => item.itemAnswer !== 0)
					.length
			)
		}, 0)
	}
	VUE = new Vue({
		el: '#app',
		components: {
		},
		data: {
			previewUrl: BASE_URL,
			userType: gemhoUtil.getCookie('userType'),
			id: '', // 记录id || 隐患id
			merId: '', // 商户id
			pageName: '', // 页面名称(用于记录页面来源，用于操作后返回上一页)
			flag: 'ZG_XQ', // 值为ADD新增、JC_XQ检查详情、ZG_XQ整改详情、YH_XQ隐患详情
			flag: 'ADD',
			// flag: 'JC_XQ',
			// flag: 'YH_XQ',
			from: '', // 来自指定页面，单独处理
			// 检查单信息
			deadlineOptions: ['1', '3', '5', '7'],
			checkData: [], // 提交给后端，图片使用vant结构，base64，后端处理，不走爱山东中台。（数据量大！）
			originCheckData: [],
			checkPageIndex: 0,
			noCount: 0,
			totalItems: 0,
			notNullCount: 0,
			// 外层表单信息
			checkDate: '', // 检查日期
			checkPeopleName: '', // 检查人员
			rectificationDeadline: '', // 整改截止日期
			reviewDate: '', // 隐患审核日期
			reviewRecord: '',
			yuqi:{
				show4yanqi:false,
				show4shangbao:false,
				dept:[], // 上报部门
				deadlineDate: gemhoUtil.getTargetDateYMD(3)
			},
			jujue:{
				show4modal :false,
				pushFlag: false, // 是否推送(审核拒绝时，如果true，则显示推送弹窗)
				rectificationCount: 0, // 整改次数
				reason: '', // 拒绝原因
				dept:[], // 拒绝部门 请求参数
				deptDict:[] // 列表
				
			},
			bohui:{
				show4modal :false,
				reason: '', // 拒绝原因
			},

			recordList: [],
			checkDeptName: '' ,// 检查单位
			iosFlag: gemhoUtil.isIOSStrict()
		},
		mounted() {
			/**
			 * 调转该_check_info.html页面时需要传递参数
			 * flag : ADD新增、JC_XQ检查详情、ZG_XQ整改详情、YH_XQ隐患详情
			 * id: 记录id || 隐患id
			 * pageName: 页面名称(用于记录页面来源，用于操作后返回上一页)
			 *	隐患状态    0：待整改 1：已整改 2：待审核 3：整改逾期
			 */
			this.pageName = gemhoUtil.getParameter('pageName')
			this.id = gemhoUtil.getParameter('id')
			this.merId = gemhoUtil.getParameter('merId')
			this.flag = gemhoUtil.getParameter('flag')
			this.from = gemhoUtil.getParameter('from')



			// this.flag = 'JC_XQ'
			// this.flag = 'ADD'
			if (this.flag == '2' || this.flag == '0'
				|| this.flag == '1' || this.flag == '3') { // 隐患详情
				this.getDetail4YH_XQ()
			} else if (this.flag === 'JC_XQ') { // 检查详情
				this.getDetail4JC_XQ()

			} else if (this.flag === 'ADD') { // 新增，调用模板详情方法
				this.getDetail4Template()
			}
		},
		watch: {
			checkData: {
				handler(newVal) {
					if (this.flag != 'ADD' && this.flag != 'JC_XQ') {
						return
					}
					const snapshot = JSON.parse(JSON.stringify(newVal));
					console.log('全量变化:', snapshot);
					this.noCount = countSelectedNo(snapshot); // selected=no 的个数
					// this.totalItems = getTotalCheckListItems(newVal); // checkList 子元素总数
					this.notNullCount = countSelectedNotNull(snapshot); // selected 不为 null 的个数
				},
				deep: true
			}
		},
		methods: {
			// showShangbao(){
			// 	this.yuqi.show4shangbao=true;
			// 	this.yuqi.dept=[];
			// 	this.getDept4yuqi();
			// },
			// getDept4yuqi(param) {
			// 	http2.post({
			// 		serviceId: API_KEY_MAP["no-page"]['id'],
			// 		interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
			// 		interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
			// 		reqParams: {
			// 			sign: 28, // 逾期上报列表获取
			// 		}
			// 	}, (res) => {
			// 		if (!res) { // 中台返回为undefined 重新请求
			// 			vant.Toast.clear()
			// 			setTimeout(() => {
			// 				this.getDept4yuqi()
			// 			}, 0);
			// 			return
			// 		}
			// 		if (res) {
			// 			setTimeout(() => {
			// 				this.$nextTick(() => {
			// 					vant.Toast.clear()
			// 				})
			// 			}, 0);
			// 			var result = JSON.parse(res)
			// 			console.log('接口回调数据getDept4jujue', JSON.parse(res))
			// 			this.yuqi.deptDict = result.data

			// 		}
			// 	})
			// },
			// getDept4jujue(param) {
			// 	http2.post({
			// 		serviceId: API_KEY_MAP["no-page"]['id'],
			// 		interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
			// 		interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
			// 		reqParams: {
			// 			sign: 26, // 2次拒绝上报列表获取
			// 		}
			// 	}, (res) => {
			// 		if (!res) { // 中台返回为undefined 重新请求
			// 			vant.Toast.clear()
			// 			setTimeout(() => {
			// 				this.getDept4jujue()
			// 			}, 0);
			// 			return
			// 		}
			// 		if (res) {
			// 			setTimeout(() => {
			// 				this.$nextTick(() => {
			// 					vant.Toast.clear()
			// 				})
			// 			}, 0);
			// 			var result = JSON.parse(res)
			// 			console.log('接口回调数据getDept4jujue', JSON.parse(res))
			// 			this.jujue.deptDict = result.data

			// 		}
			// 	})
			// },
			goback4ios() { // 全部标记为已读
				let params = {
					merId: gemhoUtil.getCookie('merId') || '',
				}
				// 这里添加跳转逻辑
				var pageUrl = `${this.pageName}.html`
				let url = gemhoUtil.setParameter(pageUrl, params)
				gemhoUtil.navigatePage(url, '跳转中...')
			},
			showImage4camera(list, index) {
				const images = list.map((item) => {
					return this.previewUrl + item
				})
			
				vant.ImagePreview({
					images,
					startPosition: index,
					closeable: true,
				});
			},
			// 处理平面图删除
			handleDeleteFloorPlan(item, index) {
				item.photos.splice(index, 1);
			},
			paizhao(item) {
				var data = ["相册", "相机"];
				var maxSelectNum = 4;
				lightAppJssdk.notification.showMediaAlert({
					arg0: data,
					success: function(data) {
						console.log('选择菜单的数据', data)
						// formData.append('file', file.file); // 通过FormData构建要上传的文件数据
						// alert(data);
						var pam1 = {
							"url": BASE_URL + '/common/uploads',
							// url:'sdfsdfsd',
							"fileKey": "files",
							// "fileKey": "files",
							"params": {
							},
							"header": {
								'Authorization': gemhoUtil.getCookie('token'),
							},
							"chooseType": "chooseFileUpload",
							"transmissionType": 0, //1-base64 0-图片地址"maxSize": 10, "maxSelectNum": 9,
							"maxSize": 10,
							"maxSelectNum": maxSelectNum,
						}
						if (data.index == 0) {
							pam1.chooseType = "chooseImageUpload" // pam1.fileKey = "file"
						} else if (data.index == 1) {
							pam1.chooseType ="takingPicturesUpload" // pam1.fileKey = "picfile"
						}
						
						
						console.log('请求接口i偶路径', pam1)
						
						chooseFileUploadTest(pam1)
						// setTimeout('onHidePreloaders()', 2000);
					},
					fail: function(data) {
						console.log(data);
					}
				});
			
				function chooseFileUploadTest(pam) {
					lightAppJssdk.uploadFile.chooseFileUpload({
						arg0: pam,
						success: function(value) {
							console.log(value, 'chooseFileUploadTest图片上传回调')
							if(value){
								// item.photos.push(...JSON.parse(value).fileNames)
								if(gemhoUtil.isIOSStrict() || gemhoUtil.isHarmonyOS()){ // ios直接返回对象
									item.photos.push(...value.fileNames)
								}else{ // 俺安卓机 返回字符串
									item.photos.push(...JSON.parse(value).fileNames)
								}
								if(item.photos.length > maxSelectNum){
									const result = item.photos.slice(0, maxSelectNum)
									item.photos = result
								}
							}
						},
						fail: function(data1) {
							console.log(data1);
						}
					});
				};
			},
			
			
			extendShow(item){ // 特殊检查项综合处理方法 选择是现实表单
				if(YES_YH_NO.includes(item.id)){
					return item.itemAnswer === 1
				}
				return item.itemAnswer === 2
			},
			shangbao(type){
				let reqParams = {
					sign: 27, // 上报
					"hdId": this.id,
				}

				if(type===1){ // 为1，则是延期
					reqParams.type = type
				}else{ // 上报
					// if(!this.yuqi.dept.length){
					// 	vant.Dialog.alert({
					// 		title: '信息提示',
					// 		message: '请选择要上报的部门'
					// 	})
					// 	return
					// }
					// reqParams.reportedIds = this.yuqi.dept
				}
		
				http2.post({
					serviceId: API_KEY_MAP["submit"]['id'],
					interfacePublicKey: API_KEY_MAP["submit"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["submit"]["privateKey"],
					reqParams
				}, (response) => {
					console.log('预期上报', response, response.code===200)
					const res = JSON.parse(response)
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.shangbao()
						}, 0);
						return
					}
					if (res) {
						if(res.code === 200){
							vant.Toast({
								message: '操作成功'
							})
							// this.yuqi.show4yanqi = false
							setTimeout(() => {
								gemhoUtil.navigatePage(`${this.pageName}.html${window.location.search}`, '操作完成,跳转中...')
							}, 1000);
						}else{
							vant.Toast({
								message: '操作失败',
							})
						}
					}
				})
			},
			prevPage(){
				this.checkPageIndex--
			},
			validRequired() {
				if (this.flag == 'JC_XQ') { // 检查详情，不参与下一页校验
					this.checkPageIndex++;
					return true
				}
				const currentPageData = this.checkData[this.checkPageIndex];
				const errorRows = currentPageData.gqCheckItemList.filter((item) => {
					console.log(item)
					
					if(YES_YH_NO.includes(item.id)){
						if (item.itemAnswer === 1) {
							return !item.description || !item.photos?.length || !item.deadlineDays
						}
					}else{
						if (item.itemAnswer === 2) {
							return !item.description || !item.photos?.length || !item.deadlineDays
						}
					}
					// if (item.itemAnswer === 2) {
					// 	return !item.description || !item.photos?.length || !item.deadlineDays
					// }
					return false
				})
				console.log('errorRows.length', errorRows.length)
				if (errorRows.length) {
					vant.Dialog.alert({
						title: '信息提示',
						message: '请填写完整信息，必填项不可为空',
					})
					return
				}

				this.checkPageIndex++;
			},
			getOriginMatchedItemById(id) {
				const result = this.originCheckData[this.checkPageIndex]['gqCheckItemList'].find(item =>
					item.id === id) || []
				return JSON.parse(JSON.stringify(result))
			},
			// 处理单选变化
			handleSelectionChange(val, item, index) {
				console.log(val, item, '数据改变了前')
				const newItem = this.getOriginMatchedItemById(item.id)
				console.log(val, newItem, '数据改变了。。。。newItem')
				newItem.itemAnswer = val
				// console.log(this.checkData[this.checkPageIndex]['gqCheckItemList'])
				this.$set(this.checkData[this.checkPageIndex]['gqCheckItemList'], index, JSON.parse(JSON
					.stringify(newItem)));
				console.log(val, this.checkData[this.checkPageIndex]['gqCheckItemList'][index], '数据改变了后',
					index)
			},
			// 文件上传处理
			handleFileUpload(file) {
				console.log('上传文件:', file);
				// 此处可添加实际文件上传逻辑
			},
			// 整改天数确认
			handleDeadlineConfirm(event, item) {
				console.log('select选择', event.target.value)
				const value = event.target.value;
				if (value) {
					const days = parseInt(value);
					item.deadlineDays = days;
					const deadlineDate = new Date();
					deadlineDate.setDate(deadlineDate.getDate() + days);
					item.deadlineDate = this.formatDate(deadlineDate);
				}
				// this.showDeadlinePicker = false;
			},
			// 日期格式化
			formatDate(date) {
				return `${date.getFullYear()}-${(date.getMonth() + 1).toString().padStart(2, '0')}-${date.getDate().toString().padStart(2, '0')}`;
			},
			getDetail4Template() { // 安全检查模板初始化
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				setTimeout(() => {
					http2.post(
						{
							serviceId: API_KEY_MAP['no-page']['id'],
							interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
							reqParams: {
								sign: 5,
							},
						},
						(res) => {
							// console.log('接口回调数据1111template', res)
							if (!res) { // 中台返回为undefined 重新请求
								vant.Toast.clear()
								setTimeout(() => {
									// this.getDetail4Template()
								}, 0);
								return
							}
							if (res) {
								// console.log('接口回调数据', JSON.parse(res))
								setTimeout(() => {
									this.$nextTick(() => {
										vant.Toast.clear()
									})
								}, 0);
								var result = JSON.parse(res)
								this.checkDate = result.data.checkDate // 检查日期
								this.checkPeopleName = result.data.checkPeopleName // 检查人员
								this.rectificationDeadline = result.data.rectificationDeadline // 整改截止日期
								this.reviewDate = result.data.reviewDate // 隐患审核日期
								this.reviewRecord = result.data.reviewRecord
								this.totalItems = result.itemAllCount
								// 表单数据
								this.checkData = JSON.parse(JSON.stringify(result.data.gqCheckTypeList))
								this.originCheckData = JSON.parse(JSON.stringify(result.data.gqCheckTypeList))
								countSelectedNo(this.originCheckData);
								countSelectedNotNull(this.originCheckData)

							}
						}
					)
				}, 0)
			},
			getDetail4YH_XQ() { // 隐患详情
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["no-page"]['id'],
					interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
					reqParams: {
						sign: 4, // 隐患详情
						"hdId": this.id,
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDetail4YH_XQ()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.checkDate = result.checkDate // 检查日期
						this.checkPeopleName = result.checkPeopleName // 检查人员
						this.rectificationDeadline = result.rectificationDeadline // 整改截止日期
						this.reviewDate = result.reviewDate // 隐患审核日期
						this.reviewRecord = result.reviewRecord

						// 2025年6月18日 新增返回字段 隐患整改、逾期上报等
						this.jujue.pushFlag =  result.pushFlag
						this.jujue.rectificationCount =  result.rectificationCount
						this.recordList = result.recordList
						this.checkDeptName = result.checkDeptName // 检查单位

						// 表单数据
						this.checkData = result.data
					}
				})

			},
			getDetail4JC_XQ() { // 检查单详情
				console.log('jiancha详情')
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				setTimeout(() => {
					http2.post(
						{
							serviceId: API_KEY_MAP['no-page']['id'],
							interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
							reqParams: {
								sign: 2,
								"recordId": this.id,
							},
						},
						(res) => {

							if (res) {
								setTimeout(() => {
									this.$nextTick(() => {
										vant.Toast.clear()
									})
								}, 0);
								console.log('接口回调数据检查详情', JSON.parse(res))
								// setTimeout(() => {
								// 	this.$nextTick(() => {
								// 		vant.Toast.clear()
								// 	})
								// }, 0);
								var result = JSON.parse(res)
								this.checkDate = result.data.checkDate // 检查日期
								this.checkPeopleName = result.data.checkPeopleName // 检查人员
								this.checkData = result.data.gqCheckTypeList
								this.noCount = result.data.hiddenCount
								this.notNullCount = result.data.notRectifiedCount
								this.totalItems = result.itemAllCount

								// 表单数据
								this.originCheckData = JSON.parse(JSON.stringify(result.data.gqCheckTypeList))
								countSelectedNo(this.originCheckData);
								countSelectedNotNull(this.originCheckData)

							}
						}
					)
				}, 0)
			},
			// add4DZG_XQ() {
			// 	console.log('整改图片', this.checkData[0]['gqCheckItemList'][0].photos)
			// 	if (!this.checkData[0]['gqCheckItemList'][0].photos.length) {
			// 		vant.Dialog.alert({
			// 			message: '请上传整改图片',
			// 		})
			// 		return;
			// 	}
			// 	vant.Toast.loading({
			// 		message: '正在处理...',
			// 		forbidClick: true,
			// 		loadingType: 'spinner',
			// 	});
			// 	http2.post({
			// 		serviceId: API_KEY_MAP["submit"]['id'],
			// 		interfacePublicKey: API_KEY_MAP["submit"]["publicKey"],
			// 		interfacePrivateKey: API_KEY_MAP["submit"]["privateKey"],
			// 		reqParams: {
			// 			 sign: 7,
			// 			"hdId": this.id,
			// 			"photos": this.checkData[0]['gqCheckItemList'][0].photos,
			// 		}
			// 	}, (res, type) => {
			// 		if (!res && !type) { // 如果是中台接口返回为undefined，则重新发起请求
			// 			vant.Toast.clear()
			// 			setTimeout(() => {
			// 				this.add4DZG_XQ()
			// 			}, 0);
			// 			return
			// 		}
			// 		if (res) {
			// 			console.log('添加结果', res)
			// 			vant.Toast({
			// 				message: '操作成功',
			// 			})
			// 			// history.back()
			// 			gemhoUtil.navigatePage(this.pageName + '.html', '操作完成,跳转中...')
			// 		}
			// 	})
			// },
			bohuiFunc() {
				vant.Toast.loading({
					message: '正在处理...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				let reqParams = {
					sign: 37,
					"hdId": this.id,
					reason:  this.bohui.reason,
				}
				
				http2.post({
					serviceId: API_KEY_MAP["submit"]['id'],
					interfacePublicKey: API_KEY_MAP["submit"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["submit"]["privateKey"],
					reqParams
				}, (res, type) => {
					if (res) {
						console.log('添加结果', res)
						var result = JSON.parse(res)
						if(result.code === 200){
							vant.Toast({
								message: '操作成功',
							})
							// history.back()
							setTimeout(() => {
								gemhoUtil.navigatePage(`${this.pageName}.html${window.location.search}`, '操作完成,跳转中...')
							}, 1000);
						}else{
							vant.Toast({
								message: '操作失败',
							})
						}
					}
				})
			},
			add4DZG_XQ() {
				console.log('整改图片', this.checkData[0]['gqCheckItemList'][0].photos)
				if (!this.checkData[0]['gqCheckItemList'][0].photos.length) {
					vant.Dialog.alert({
						message: '请上传整改图片',
					})
					return;
				}
				vant.Toast.loading({
					message: '正在处理...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				var reqParam = {
					"hdId": this.id,
					"photos": this.checkData[0]['gqCheckItemList'][0].photos,
				}
				// var url = "/gq/checkRecord/safeCheckRecord"

				http3.post('/gq/hiddenDanger/rectification', reqParam).then((result) => {
					console.log('添加结果', result)
					if(result.code === 200){
						vant.Toast({
							message: '操作成功',
						})
						// history.back()
						setTimeout(() => {
							gemhoUtil.navigatePage(`${this.pageName}.html${window.location.search}`, '操作完成,跳转中...')
						}, 1000);
					}else{
						vant.Toast({
							message: result.msg || '操作失败',
						})
					}
				})
			},
			// add4DSH_XQ(auditStatus) { // 隐患详情 审核通过或拒绝
			// 	vant.Toast.loading({
			// 		message: '正在处理...',
			// 		forbidClick: true,
			// 		loadingType: 'spinner',
			// 	});
			// 	var reqParam = {
			// 		"hdId": this.id,
			// 		auditStatus
			// 	}
			// 	http3.post('/gq/hiddenDanger/audit', reqParam).then((res) => {
			// 		console.log('添加结果', res)
			// 		vant.Toast({
			// 			message: '操作成功',
			// 		})
			// 		gemhoUtil.navigatePage(this.pageName + '.html', '操作完成,跳转中...')
			// 	})
			// },
			showImage(list, index) {
				vant.ImagePreview({
					images: list,
					startPosition: index,
					closeable: true,
				});
			},
			validRefuse(auditStatus){
				this.jujue.show4modal = true
				this.jujue.reason = ''
				if(this.jujue.pushFlag){ // 需要上报的时候，清理
					this.jujue.dept = []
					this.getDept4jujue()
				}
			},
			add4DSH_XQ(auditStatus) { // 隐患详情 审核通过或拒绝
				vant.Toast.loading({
					message: '正在处理...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				let reqParams = {
					sign: 8,
					"hdId": this.id,
					auditStatus,
				}

				 // 2025年6月18日 新增逻辑： 如果是拒绝，且需要上报，则额外添加上报参数
				if(auditStatus==0){
					reqParams.reason = this.jujue.reason
					// if(this.jujue.pushFlag){
					// 	reqParams.reportedIds = this.jujue.dept
					// }
				}

				http2.post({
					serviceId: API_KEY_MAP["submit"]['id'],
					interfacePublicKey: API_KEY_MAP["submit"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["submit"]["privateKey"],
					reqParams
				}, (res, type) => {
					if (!res && !type) { // 如果是中台接口返回为undefined，则重新发起请求
						vant.Toast.clear()
						setTimeout(() => {
							this.add4DSH_XQ(auditStatus)
						}, 0);
						return
					}
					if (res) {
						console.log('添加结果', res)
						var result = JSON.parse(res)
						if(result.code === 200){
							vant.Toast({
								message: '操作成功',
							})
							// history.back()
							setTimeout(() => {
								gemhoUtil.navigatePage(`${this.pageName}.html${window.location.search}`, '操作完成,跳转中...')
							}, 1000);
						}else{
							vant.Toast({
								message: result.msg || '操作失败',
							})
						}
					}
				})
			},
			add4JC_XQ() {
				var reqParam = {
					"merId": this.merId,
					"gqCheckTypeList": this.checkData,
				}
				// var url = "/gq/checkRecord/safeCheckRecord"

				http3.post('/gq/checkRecord/safeCheckRecord', reqParam).then((res) => {
					console.log('添加结果', res)
					if (res.code === 200) {
						vant.Toast({
							message: '操作成功',
						})
						gemhoUtil.navigatePage(`${this.pageName}.html${window.location.search}`, '操作完成,跳转中...')
					} else {
						vant.Toast({
							message: '操作失败',
						})
					}
				})
			}
		}
	});
}
