/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				form: {
					hdId: '',
					// 检查日期
					hdInspectDate: '',//2024-03-08 00:00:00',
					// 检查人员
					hdInspectExpert: '',//'发发发',
					// 隐患类型
					hdLevel: '1',
					
					type: '',// 安全类别
					category: '',// 安全检查类别,
					inspectionContent: '',//'安全检查内容',
					hdName: '',// 发现问题
					comment: '',//"隐患描述",
					basis: '',//'测试依据',// 检查依据
					suggestion: '',//'测试建议',// 整改建议
					recDeadLine:'', // 整改期限
					hdPic: null,	// 隐患图片
					hdRectificationPic: null,// 隐患整改图片
					// 整改图片文件路径
					rectFilePath: '',
					// 审核人
					hdAcceptancePerson: "",
					hdRectificationRecord: '',
					hdStatus: 0, // 整改中
				},
				// 企业id
				disabled: true,

				fileList: [],
			}
		},
		mounted() {
			if(gemhoUtil.getParameter('type') === 'detail'){
				this.disabled = true
			}else if(gemhoUtil.getParameter('type') === 'edit'){
				this.disabled = false
			}
			this.detail()
		},
		computed:{
			hdLevelText(){
				return this.form.hdLevel===1 ? '一般隐患' : '重大隐患'
			}
		},
		methods: {
			beforeRead(file) {
				if(!['image/png','image/jpeg','image/jpg'].includes(file.type)){
					  vant.Dialog.alert({
						title: '信息提示',
						message: '文件格式不正确'
					  })
					return;
				}
				console.log('beforeRead', file.size)
				if (file.size > (10 * 1024 * 1024)) {
					vant.Dialog.alert({
						title: '信息提示',
						message: '文件大小不可超过10M'
					})
					return false;
				}
				return true;
			},
			detail(){
				vant.Toast.loading({
					message: '加载中...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				
				http2.post({
					serviceId: API_KEY_MAP["yh-list"]['id'],
					interfacePublicKey: API_KEY_MAP["yh-list"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["yh-list"]["privateKey"],
					reqParams: {
						page: 0,// 每次请求增加下一页
						size: 1,
						hdId: gemhoUtil.getParameter('hdId'),
						sort: 'hdId,desc',
					}
				}, (res) => {
					if(!res){ // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.detail()
						}, 0);
						return
					}
					if(res){
						console.log('接口回调数据', JSON.parse(res))
						var result = JSON.parse(res)
						this.loading = false; // 加载状态结束
						
						// console.log('响应结果', result.content)
						this.form = result.content[0]
						if(this.form.hdPic && this.form.hdPic.length){
							this.form.hdPic = this.form.hdPic[0]
						}
						// 整改图片编辑 上传组件图片赋值
						if(this.form.hdRectificationPic && this.form.hdRectificationPic.length && !this.disabled){
							this.fileList.push({
								content: 'data:image/jpg;base64,' + this.form.hdRectificationPic[0]
							})
						}
						
						// 隐患状态 成功和待验证 则不允许编辑
						this.disabled = this.form.hdStatus === 1 || this.form.hdStatus === 3 
						setTimeout(() => {
							this.$nextTick(()=>{
								vant.Toast.clear()
							})
						}, 0);
						
					}
				})
			},
			submit() {
				if (!this.fileList.length) {
					vant.Dialog.alert({
						message: '没有整改照片',
					})
					return
				}
				vant.Toast.loading({
					message: '正在处理...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				const formData = new FormData();
				formData.append('hdRectificationPic', this.fileList[0].file); // 通过FormData构建要上传的文件数据
				formData.append('biz_content', SM.encrypt(this.form.hdId, API_KEY_MAP["yh-list-detail"]["publicKey"]));
							
				// 发送HTTP POST请求
				fetch(BASE_URL + '/api/thHiddenDanger/update', { 
					method: 'POST',
					headers: {
						Authorization: gemhoUtil.getCookie('token')
					},
					body: formData
				})
				.then(response => {
					if (response.ok) {
						return response.json();
					}
					throw new Error('Network response was not ok.');
				})
				.then(value => {
					console.log(value); // 处理后端返回的数据
					if(value){ // 返回信息不为空，则进行解密操作
						let sm2_encrypt_result = value // 后台返回待解密内容
						let sm2_decrypt_result = sm2_Decrypt(sm2_encrypt_result, API_KEY_MAP["yh-list-detail"]["privateKey"],)
						console.log('yh-list-detail响应解密', sm2_decrypt_result)
						const decryptRes = JSON.parse(sm2_decrypt_result)
						if(decryptRes.code === 400 || decryptRes.code === 401 || decryptRes.status === 401){
							vant.Dialog.alert({
								title: '信息提示',
								message: decryptRes.msg,
							})
							return
						}
						// 可根据后端返回的数据做进一步处理，如显示上传成功信息等
						gemhoUtil.navigatePage('./yh-list.html', '操作完成,页面跳转中...')
					}
				})
				.catch(error => {
					// console.error('There has been a problem with your fetch operation:', error);
				});
			},
			
			// submit() {
			// 	if (!this.fileList.length) {
			// 		vant.Dialog.alert({
			// 			message: '没有整改照片',
			// 		})
			// 		return
			// 	}
			// 	vant.Toast.loading({
			// 		message: '正在处理...',
			// 		forbidClick: true,
			// 		loadingType: 'spinner',
			// 	});
			// 	http2.post({
			// 		serviceId: API_KEY_MAP["yh-list-detail"]['id'],
			// 		interfacePublicKey: API_KEY_MAP["yh-list-detail"]["publicKey"],
			// 		interfacePrivateKey: API_KEY_MAP["yh-list-detail"]["privateKey"],
			// 		reqParams: {
			// 			hdId: this.form.hdId,
			// 		},
			// 		fileList: [{
			// 			fileName: 'hdRectificationPic',
			// 			file: this.fileList[0].file
			// 		}]
			// 	}, (res) => {
						
			// 		if(res){
			// 			// console.log('接口回调数据', JSON.parse(res))
						
			// 			var result = JSON.parse(res)
			// 			this.loading = false; // 加载状态结束
						
			// 			// console.log('响应结果', result)
					
			// 			// vant.Toast.clear()
			// 			// vant.Toast({
			// 			// 	message: '操作完成',
			// 			// })
			// 			// location.href="./yh-list.html"
			// 			// gemhoUtil.navigatePage('./yh-list.html', '操作完成,页面跳转中...')
					
			// 		}
			// 	})
			// },
		},
	});
});