var VUE = null
window.addEventListener('load', function () {

	// 在原有Vue实例中添加
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				formData: {
				},
				// 添加显示状态管理对象
				showOriginal: {
					contactName: false,
					contactDetails: false
				}
			}
		},
		computed: {},
		mounted() {
			this.detail()
		},
		methods: {
			// 添加脱敏处理函数
			desensitize(value, type) {
				if (!value) return '';
				switch(type) {
				case 'name': // 姓名脱敏：保留姓氏
					return value.length > 1 ? value.charAt(0) + '*'.repeat(value.length - 1) : value;
				case 'phone': // 手机号脱敏：保留前3后4
					return value.replace(/^(\d{3})\d{4}(\d{4})$/, '$1****$2');
				default: 
					return value;
				}
			},
			// 添加显示切换方法
			toggleShow(field) {
				this.$set(this.showOriginal, field, !this.showOriginal[field]);
			},
			detail() {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["no-page"]['id'],
					interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
					reqParams: {
						sign: 19,
						"feedbackId": gemhoUtil.getParameter('id'),
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.detail()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据=建议详情', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.formData = result.data
					}
				})
			},
			showImage(list, index) {
				vant.ImagePreview({
					images: list,
					startPosition: index,
					closeable: true,
				});
			},
		},
	})
})

