var VUE = null
	window.addEventListener("pageshow", (event) => {
		console.log(event, 'event')
		 if (event.persisted) { // 从 BF Cache 加载时触发
			location.reload(); // 强制刷新
		}
	});
window.onload = function() {
	// const currentDate = gemhoUtil.getTargetDateYM()
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				isLoading: true, // 新增：加载状态标记
				showPopup4completionDate: false, // 控制日期选择器弹窗的显示与隐藏
				showOrg: false, //是否显示组织
				showShop: false, //是否显示店铺
				// 存储选择的日期
				selectedDate: '', // new Date(currentDate), // '', // gemhoUtil.formatDate(new Date(value)),
				//显示的日期
				showDate: '', // currentDate,
				// 日期选择的最小范围，这里设置为当前日期的前 10 年
				minDate: new Date('2025-01-01'),
				// 日期选择的最大范围，这里设置为当前日期的后 10 年
				// maxDate: new Date(new Date().getFullYear() + 10, 11),
				maxDate: new Date('2045-01-01'),
				userInfo: {
					userType: '', // 登录用户type
					userId: '1', // 登录用户id
					userName: '', // 登录用户name
					deptId: '1', // 登录用户部门id
					deptName: '', // 登录用户部门name
					safeLevel: '0', //0:绿、1:黄、2:红
					role: '',
					roleName: '',
				},
				// 初始化为空数组，等待接口数据填充
				userData: {
					checkCount: 0, //检查数
					checkSelfCount: 0, //自查数
					hiddenCount: 0, //隐患数
					hiddenNoReCount: 0, //未整改数
				},
				accessType: 'manage', // 访问类型  shop商家 saoma 扫码 manage 管理
				// 修改默认菜单结构为最小化配置
				menuList: [],
				remindStatistic: [],
				errorReqCount: 0,
			}
		},
		mounted() {
			this.init()
		},
		methods: {
			async init() {
				// 在组件挂载后执行
				await this.getUserInfo();
				await this.getStatisticData();
				this.isLoading = false; // 数据加载完成后关闭加载状态
			},
			getRemindStatistic() {
				http2.post({
						serviceId: API_KEY_MAP['no-page']['id'],
						interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
						interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
						reqParams: {
							sign: 23, // 商户首页统计
						},
					},
					(res) => {
						if (!res) {
							// 中台返回为undefined 重新请求
							console.log('getRemindStatistic方法返回null！！')
							this.getRemindStatistic()
							return
						}
						if (res) {
							var result = JSON.parse(res)
							this.remindStatistic = result.data
						}
					}
				)
			},
			scanCode(toData) { // 有菜单地址则是跳转页面，没有则是扫码操作
				if (toData) {
					let param = {
						accessType: this.accessType,
						merId: this.userInfo.merId || '',
						unitName: this.userInfo.unitName,
						smallPlaceTypeName: this.userInfo.smallPlaceTypeName,
						rev: (+new Date())
					}
					if (gemhoUtil.isShop()) {
						param = {
							...param,
							accessType: 'shop',
						}
						if (toData == 'check_info') {
							param = {
								...param,
								accessType: 'shop',
								flag: 'ADD',
								pageName: '../home',
							}
						}
					}
					
					let url = gemhoUtil.setParameter(`src/_${toData}.html`, param)
					gemhoUtil.navigatePage(url, '跳转中...')
					
				} else {
					lightAppJssdk.device.scan({
						success: function(data) {
							// 获取到data为二维码的url路径，从这里取请求参数，商户id，在下面跳转本地系统路径
							// alert('扫码成功'+JSON.stringify(data))
							const strUrl = new URL(data);
							const param = {
								merId: strUrl.searchParams.get('merId'),
								accessType: strUrl.searchParams.get('accessType'),
								rev: (+new Date())
							};
							if (param.merId == null || param.merId == '') {
								alert('请扫描正确的商家店面二维码')
								return
							} else {
								let url = gemhoUtil.setParameter(`./src/_shanghu_home.html`,
									param)
								gemhoUtil.navigatePage(url, '跳转中...')
							}
					
						},
						fail: function(data) {
							//错误返回
							alert('扫码失败')
						},
					})
				}
			},
			getUserInfo() {
				return new Promise((resolve) => {
					http2.post({
							serviceId: API_KEY_MAP['no-page']['id'],
							interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
							reqParams: {
								sign: 9,
							},
						},
						(res) => {
							if (res) {
								var result = JSON.parse(res)
								
								if (result.code !== 200 && result.data == null) {
									// 中台返回为undefined 重新请求
									console.log('getUserInfo=>code200datanull')
									setTimeout(() => {
										// 如果加载成功后，就不在继续加载页面接口了。处理settimeout堆积问题
										if(!this.isLoading){
											return
										}
										if(this.errorReqCount <= 5){
											this.errorReqCount++
											this.init() // 请求错误后，重新发起请求
										}
									}, 0)
									return
								}
								
								
								this.userInfo = {
									userType: result.data.roleDeptNameVo
									.userType, // 登录用户type
									userId: '1', // 登录用户id
									userName: '张三', // 登录用户name
									deptId: '1', // 登录用户部门id
									safeLevel: result.data.merchantInfoNumVo
									?.safeLevel, //0:绿、1:黄、2:红
									deptName: result.data.roleDeptNameVo
									.deptName, // 登录用户部门name
									businessAddress: result.data.merchantInfoNumVo
										?.businessAddress, //
									smallPlaceTypeName: result.data.merchantInfoNumVo
										?.smallPlaceTypeName, //
									unitName: result.data.merchantInfoNumVo?.unitName, //
									role: 'dudao',
									roleName: result.data.roleDeptNameVo?.roleName,
									merId: result.data.merchantInfoNumVo?.id, //
								}
								gemhoUtil.setCookie('merId', this.userInfo.merId || '')
								gemhoUtil.setCookie('userType', this.userInfo.userType)
								if (gemhoUtil.isShop()) { // 2025年5月14日新增消费者逻辑
									this.showOrg = false //是否显示组织
									this.showShop = true //是否显示店铺
									this.getRemindStatistic() // 2025年6月9日 新增珊瑚提醒

								} else {
									this.showOrg = true //是否显示组织
									this.showShop = false //是否显示店铺
								}

								// console.log('菜单', result.data.modules)
								// 生成最终菜单列表
								this.menuList = result.data.modules
								gemhoUtil.setCookie('yesItemIds',result.data.itemIds.join(','))
								resolve();
							}
						})
				});
			},
			// 获取用户数据的方法
			getStatisticData() {
				return new Promise((resolve) => {
					http2.post({
							serviceId: API_KEY_MAP['no-page']['id'],
							interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
							reqParams: {
								sign: 6,
								date: this.selectedDate,
								merId: gemhoUtil.getParameter('merId') || '',
							},
						},
						(res) => {
							if (!res) {
								// 中台返回为undefined 重新请求
								console.log('getRemindStatistic方法返回null！！')
								setTimeout(() => {
									// 如果加载成功后，就不在继续加载页面接口了。处理settimeout堆积问题
									if(!this.isLoading){
										return
									}
									if(this.errorReqCount <= 5){
										this.errorReqCount++
										this.init() // 请求错误后，重新发起请求
									}
								}, 0)
								return
							}
							if (res) {
								var result = JSON.parse(res)
								console.log('用户Data', result)
								this.userData = result.data
								resolve();
							}
						}
					)
				});
			},
			showPopup() {
				this['showPopup4completionDate'] = true
			},
			confirm4completionDate(value) {
				this.selectedDate = gemhoUtil.getTargetDateYMByPara(value)
				this.showDate = gemhoUtil.getTargetDateYMByPara(value)
				this.showPopup4completionDate = false
				this.getStatisticData()
			},

			// 格式化日期显示的函数，根据需要自定义
			needData(type, val) {
				if (type === 'year') {
					return `${val}`
				} else if (type === 'month') {
					return `${val}`
				}
				return val
			},
			// 取消选择日期时的回调函数
			onCancel() {
				this.showPicker = false
			},
			openDebug() { // 双击开启debugg模式，再次双击则关闭
				console.log('开启关闭debug')
				if (localStorage.getItem('debug') == 'Y') {
					localStorage.setItem('debug', 'N')
				} else {
					localStorage.setItem('debug', 'Y')
				}
			},
			navTo(type) { // 消息统计跳转
				const param = {
					type,
					merId: this.userInfo.merId
				};
				let url = gemhoUtil.setParameter(`./src/_yh_check.html`, param)
				gemhoUtil.navigatePage(url, '跳转中...')
			},
			gotoPage(stringifyUrl) {
				let url = gemhoUtil.setParameter(`src/_${stringifyUrl}.html`)
				gemhoUtil.navigatePage(url, '跳转中...')
			},
		},
		//过滤器
		filters: {
			//格式化日期显示的函数，根据需要自定义
			formatterData(val) {
				if (!val) return ''
				const [year, month] = val.split('-')
				return `${year}年${month}月`
			},
		},

	})
}