var VUE = null
window.addEventListener('load', function () {
  VUE = new Vue({
    el: '#app',
    data() {
      return {
        // 新增子Tab数据
        activeTab: '1',
        hazardList: [
          // 更多示例数据...
        ],
        // 新增以下数据
        userInfo: {},
        userData: {
          checkCount: 0, //检查数
          checkSelfCount: 0, //自查数
          hiddenCount: 0, //隐患数
          hiddenNoReCount: 0, //未整改数
        },
        page: 1,
        size: 10,
        merId: null, // 商户id
        unitName: '', // 单位名称
        smallPlaceTypeName: '', // 场所类型
      }
    },
    created() {
      let urlParams = gemhoUtil.getUrlParams()
      this.merId = urlParams.merId
      this.unitName = urlParams.unitName
      this.smallPlaceTypeName = urlParams.smallPlaceTypeName
      this.init()
    },
    computed: {},
    methods: {
      //初始化页面
      init() {
        this.getUserData()
        this.getMerchantSelfCheckData()
      },
      /**请求数据 */
      // 获取用户数据的方法
      getUserData() {
        // http
        //   .get('/gq/checkRecord/merHomeStatistics?date=' + this.selectedDate)
        //   .then((res) => {
        //     if (res.code == 200) {
        //       this.userData = res.data
        //     }
        //   })  
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
        setTimeout(() => {
          http2.post(
            {
              serviceId: API_KEY_MAP['no-page']['id'],
              interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
              reqParams: {
                sign: 6,
                merId: this.merId,
                pageNum: this.page++, // 每次请求增加下一页
                pageSize: this.size,
                date: this.selectedDate,
                sort: 'lawId,desc',
              },
            },
            (res) => {
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  // this.getList()
                }, 0)
                return
              }
              if (res) {
                var result = JSON.parse(res)
                this.userData = result.data
              }
            }
          )
        }, 0)
      },
      //获取商户自查数据
      getMerchantSelfCheckData() {
        // 更多示例数据...
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
        setTimeout(() => {
          http2.post(
            {
              serviceId: API_KEY_MAP['page']['id'],
              interfacePublicKey: API_KEY_MAP['page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
              reqParams: {
                sign: 1,
                type: this.activeTab,
                merId: this.merId,
                pageNum: this.page, // 每次请求增加下一页
                pageSize: this.size,
                sort: 'lawId,desc',
              },
            },
            (res) => {
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  // this.getList()
                }, 0)
                return
              }
              if (res) {
                var result = JSON.parse(res)
                if (result.code !== 200 && result.data == null) {
                  return
                }
                this.hazardList = result.rows
                if (this.page * this.size >= this.total) {
                  this.finished = true // 下滑不在刷新数据
                }else{this.page++}
              }
              this.loading = false
              setTimeout(() => {
                this.$nextTick(() => {
                  vant.Toast.clear()
                })
              }, 0)
              this.$nextTick(() => {
                // 滚动条跳转位置
                window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'))
              })
            }
          )
        }, 0)
      },
      viewDetail(id) {
        let urlParams = gemhoUtil.getUrlParams()
        let param = {
          ...urlParams,
          id: id,
          flag: 'JC_XQ',
          pageName: '_checkrecord',
        }
        let url = gemhoUtil.setParameter('_check_info.html', param)

        gemhoUtil.navigatePage(url, '跳转中...')
        // 这里添加跳转逻辑
      },
    },
  })
})
