/**
 * author: dabao
 * date: 2024-03-15
 * description: 商户首页
 */
var VUE = null
window.addEventListener("load", function () {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				showDatePicker: false,  // 控制日期选择器显示
				minDate: new Date(gemhoUtil.getTargetDateYMD()),  // 最小可选日期
				maxDate: new Date(2099, 11, 31),  // 最大可选日期
				// 新增子Tab数据
				subActiveTab: 0,
				hazardList: [// 更多示例数据...
				],
				activeTab: 0,
				showTimePicker: false,
				// 新增以下数据
				showTypePicker: false,
				typeOptions: ['小餐饮', '酒店', '商场', '学校', '医疗机构'],
				formData: {
					submitDate: gemhoUtil.getTargetDateYMD(),
					createDate: gemhoUtil.getTargetDateYMD(),
					phone: '',
					area: '',
					businessHours: '',
					type: '', // 新增类型字段
				},
				checkList: [{
					id: 1,
					date: '2024-03-15',
					result: '合格'
				},
				{
					id: 2,
					date: '2024-03-14',
					result: '不合格'
				}
				],
				merId: '',
				merInformation: { // 新增商户信息对象

				},
			}
		},
		created() {
			let params = gemhoUtil.getUrlParams()
			console.log(params);
			this.merId = params.merId
		},
		mounted() {
			this.getShopInfo() // 获取商户信息
		},
		watch: {
			'formData.date': {
				handler(newVal) {
					console.log('date 属性变化:', newVal);
				},
				deep: true // 深度监听对象属性
			}
		},
		methods: {
			// 日期格式化函数（确保格式为 YYYY-MM-DD）
			dateFormatter(type, value) {
				if (type === 'year') {
					return `${value}年`;
				} else if (type === 'month') {
					return `${value}月`;
				}
				return `${value}日`;
			},
			gotoPage(stringifyUrl) {
				let url = gemhoUtil.setParameter(`src/_${stringifyUrl}.html`)
				gemhoUtil.navigatePage(url, '跳转中...')
			},
			// 确认日期选择
			onDateConfirm(date) {
				// 将 Date 对象格式化为 YYYY-MM-DD 字符串
				const year = date.getFullYear();
				const month = String(date.getMonth() + 1).padStart(2, '0');
				const day = String(date.getDate()).padStart(2, '0');
				this.formData.date = `${year}-${month}-${day}`;
				this.showDatePicker = false;
			},
			dateChange(e) {
				console.log('date 属性变化22222:', e);
			},
			// 文件上传处理
			handleFileUpload(file) {
				console.log('上传文件:', file);
				// 此处可添加实际文件上传逻辑
			},

			navTo(url) {
				// gemhoUtil.nav2asd(url)
				let params = gemhoUtil.getUrlParams()
				if (url == 'check_info') {
					params = {
						...params,
						flag: 'ADD',
						pageName: '_shanghu_home'
					}
				}
				let strurl = gemhoUtil.setParameter(`_${url}.html`, params)
				gemhoUtil.navigatePage(strurl, '跳转中...')
			},
			submitForm() {
				if (!this.formData.content) {
					vant.Dialog.alert({
						message: '安全建议不可为空',
					})
					return;
				}
				vant.Toast.loading({
					message: '正在处理...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				var reqParam = {
					merId: this.merId,
					...this.formData,
				}
				// var url = "/gq/checkRecord/safeCheckRecord"

				http3.post('/gq/consumer', reqParam).then((res) => {
					console.log('添加结果', res)
					vant.Toast({
						message: '操作成功',
					})
					// this.formData = {
					// 	submitDate: gemhoUtil.getTargetDateYMD(),
					// 	createDate: gemhoUtil.getTargetDateYMD(),
					// 	phone: '',
					// 	area: '',
					// 	businessHours: '',
					// 	type: '', // 新增类型字段
					// 	content: '',
					// 	photos: [],
					// 	contactName: '',
					// 	contactDetails: '',
					// },
					location.reload()
					// gemhoUtil.navigatePage(`${this.pageName}.html${window.location.search}`, '操作完成,跳转中...')
				})
			},
			//获取商户信息
			getShopInfo() {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				})
				setTimeout(() => {
					http2.post(
						{
							serviceId: API_KEY_MAP['no-page']['id'],
							interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
							reqParams: {
								sign: 11,
								pageNum: this.page++, // 每次请求增加下一页
								pageSize: this.size,
								merId: this.merId,
								sort: 'lawId,desc',
							},
						},
						(res) => {
							if (!res) {
								// 中台返回为undefined 重新请求
								vant.Toast.clear()
								this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
								setTimeout(() => {
									// this.getList()
								}, 0)
								return
							}
							if (res) {
								var result = JSON.parse(res)
								this.merInformation = { ...this.merInformation, ...result.data }
							}
						}
					)
				}, 0)
			},
		}
	});

})