var VUE = null
window.addEventListener('load', function () {
  VUE = new Vue({
    // 在原有Vue实例中添加
    el: '#app',
    data() {
      return {
        userType: gemhoUtil.getCookie('userType'),
        shanghuName: '',
        // 新增子Tab数据
        hazardList: [
          // 更多示例数据...
        ],
        activeTab: '',
        status: '',
        merId: '',
        showSearch: false, // 控制搜索框的显示和隐藏
        // 整改状态 0：待整改 1：已整改 2：待审核 3：整改逾期
        tabList: [
          { name: '', title: '全部', msgNum: 0, },
          { name: '2', title: '待审核', msgNum: 0, },
          { name: '0', title: '待整改', msgNum: 0, },
          { name: '1', title: '已整改', msgNum: 0, },
          { name: '3', title: '整改逾期', msgNum: 0, },
        ],
        loading: false,
        finished: false,
        page: 1,
        size: 6,
        total: 0,
        remindStatistic: [],
		reqFlag: false, // 页面列表接口请求flag 防止多次请求
      }
    },
    computed: {
    },
    created() {
      let merId = gemhoUtil.getParameter('merId')
      if (merId !== undefined && merId !== null) {
        this.merId = merId
      } else {
        this.merId = ''
      }
      // 2025年6月7日 新增首页（信息统计跳转）类别区分逻辑。
      let type = gemhoUtil.getParameter('type')
      if (type === 'nopass') {
        this.activeTab = 2
      } else if (type === 'willExpire') { // 即将超期待整改
        this.activeTab = 2
      } else if (type === 'expire') { // 超期 整改逾期
        this.activeTab = 4
      }
      if (gemhoUtil.getCookie('userType') !== 'shop') {
        this.showSearch = true
      }
      this.getRemindStatistic()

      this.init()
    },
    methods: {
      markAllAsRead() { // 全部标记为已读
        http2.post(
          {
            serviceId: API_KEY_MAP['submit']['id'],
            interfacePublicKey: API_KEY_MAP['submit']['publicKey'],
            interfacePrivateKey: API_KEY_MAP['submit']['privateKey'],
            reqParams: {
              sign: 25, // post 设置已读
			  merId: this.merId,
            },
          },
          (res) => {
            if (!res) {
              // 中台返回为undefined 重新请求
              setTimeout(() => {
                this.markAllAsRead()
              }, 0)
              return
            }
            var result = JSON.parse(res)
			if (result && result.code == 200) {
               vant.Toast({
               	message: '操作成功',
               })
			   this.hazardList.forEach(item => {
			     if (item.msgFlag) {
			       this.$set(item, 'msgFlag', false); // 动态添加响应式属性
			     }
			   });
			   
			   this.tabList.forEach(item1 => {
			       this.$set(item1, 'msgNum', 0); // 动态添加响应式属性
			   });
            }		
          }
        )
      },
      getRemindStatistic() {
        http2.post(
          {
            serviceId: API_KEY_MAP['no-page']['id'],
            interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
            interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
            reqParams: {
              sign: 24, // 隐患tab
            },
          },
          (res) => {
            if (!res) {
              // 中台返回为undefined 重新请求
              setTimeout(() => {
                this.getRemindStatistic()
              }, 0)
              return
            }
            if (res) {
              var result = JSON.parse(res)
              console.log('tab', result.data)
              this.tabList = result.data
            }
          }
        )
      },
      reset() {
        this.page = 1
        this.size = 6
        this.total = 0
		this.loading = false
		this.finished = false
		
        this.hazardList = []
      },
      yhstatus() { // tab值对应的隐患状态码装欢
        if (this.activeTab === 0) {
          return ''
        } else if (this.activeTab === 1) {
          return ~~'2'
        } else if (this.activeTab === 2) {
          return ~~'0'
        } else if (this.activeTab === 3) {
          return ~~'1'
        } else if (this.activeTab === 4) {
          return ~~'3'
        }
      },
      tabChange(title) {
        console.log('tab 切换', title)
        this.reset()
        this.getList()
      },
      init() {
        this.getList()
      },
      onSearch() {
        this.reset()
        this.getList()
      },
      // 新增选择确认方法
      onConfirmType(value) {
        this.formData.type = value
        this.showTypePicker = false
      },
      statusTagType(status) {
        const types = {
          2: 'warning',
          0: 'primary',
          1: 'success',
          3: 'danger',
        }
        return types[status] || ''
      },
      viewDetail(item) {
        let param = {
          id: item.id,
          flag: item.rectificationStatus,
          pageName: '_yh_check',
        }
        let url = gemhoUtil.setParameter('_check_info.html', param)
        console.log(url)

        gemhoUtil.navigatePage(url, '跳转中...')
        // 这里添加跳转逻辑
      },
      //获取隐患列表数据
      getList() {
			
		if(this.reqFlag){ // 第一次请求没有结束则不进行下面逻辑
			return
		}
		this.reqFlag = true
        // 这里添加获取数据的逻辑
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
          http2.post(
            {
              serviceId: API_KEY_MAP['page']['id'],
              interfacePublicKey: API_KEY_MAP['page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
              reqParams: {
                sign: 3,
                // merId: this.merId ? this.merId : '',
                merName: this.shanghuName,
                pageNum: this.page, // 每次请求增加下一页
                pageSize: this.size,
                sort: 'lawId,desc',
                status: this.yhstatus()
              },
            },
            (res) => {
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  // this.getList()
                }, 0)
                return
              }
              if (res) {
                var result = JSON.parse(res)
                console.log(result, 'result')
                this.loading = false; // 加载状态结束
                this.hazardList.push(...result.rows);
                this.total = result.total

                if (this.page * this.size >= this.total) {
                  this.finished = true; // 下滑不在刷新数据
                }else{
					this.page++
				}
              }
              this.loading = false
              setTimeout(() => {
                this.$nextTick(() => {
                  vant.Toast.clear()
				  this.reqFlag = false
                })
              }, 0);

            }
          )
      },
    },
  })
})
