/**
 * 1：根据商铺id 查询安全检查记录
 * 2：根据记录id 查询详情
 * 	3：隐患列表
	4：隐患详情
	5：查询安全检查模板数据
	6：商家首页按月查询
	9：用户角色可查看的模块
	10：查询用户检查过的商户信息
	11: 查询商户详情信息
	
	跳转逻辑：
	新增检查单，flag=ADD，
	检查单详情，flag=JC_XQ，id=记录id
	待审核隐患，flag=2，id=隐患id
	待整改隐患，flag=0，id=隐患id
	已整改隐患，flag=1，id=隐患id
	整改逾期隐患，flag=3，id=隐患id
	
	
	整改状态 0：待整改 1：已整改 2：待审核 3：整改逾期
	
 */

var VUE = null

window.onload = function() {
	function countSelectedNo(result) {
		// 获取 checkList 中 selected 为 'no' 的对象个数
		return result.reduce((total, category) => {
			return (
				total +
				category.gqCheckItemList.filter((item) => item.itemAnswer === 2)
				.length
			)
		}, 0)
	}

	function countSelectedNotNull(result) {
		// 获取 checkList 中 selected 不为 null 的个数
		return result.reduce((total, category) => {
			return (
				total +
				category.gqCheckItemList.filter((item) => item.itemAnswer !== 0)
				.length
			)
		}, 0)
	}

  VUE = new Vue({
		el: '#app',
		data: {
			userType:  gemhoUtil.getCookie('userType'),
			id: '', // 记录id || 隐患id
			merId: '', // 商户id
			pageName: '', // 页面名称(用于记录页面来源，用于操作后返回上一页)
			flag: 'ZG_XQ', // 值为ADD新增、JC_XQ检查详情、ZG_XQ整改详情、YH_XQ隐患详情
			flag: 'ADD',
			// flag: 'JC_XQ',
			// flag: 'YH_XQ',
			deadlineOptions: ['1', '3', '5', '7'],
			checkData: [], // 提交给后端，图片使用vant结构，base64，后端处理，不走爱山东中台。（数据量大！）
			originCheckData: [],
			checkPageIndex: 0,
			noCount: 0,
			totalItems: 0,
			notNullCount: 0,
			// 外层表单信息
			checkDate: gemhoUtil.getTargetDateYMD(), // 检查日期
			checkPeopleName: '', // 检查人员
			rectificationDeadline: '', // 整改截止日期
			reviewDate: '', // 隐患审核日期
			reviewRecord: '',
		},
		mounted() {
			/**
			 * 调转该_check_info.html页面时需要传递参数
			 * flag : ADD新增、JC_XQ检查详情、ZG_XQ整改详情、YH_XQ隐患详情
			 * id: 记录id || 隐患id
			 * pageName: 页面名称(用于记录页面来源，用于操作后返回上一页)
			 *	隐患状态    0：待整改 1：已整改 2：待审核 3：整改逾期
			 */
			console.log(gemhoUtil.getParameter, 'gemhoUtil.getParameter')
			this.pageName = gemhoUtil.getParameter('pageName')
			this.id = gemhoUtil.getParameter('id')
			this.merId = gemhoUtil.getParameter('merId')
			this.flag = gemhoUtil.getParameter('flag')
			
		
			
			// this.flag = 'JC_XQ'
			// this.flag = 'ADD'
			if (this.flag == '2' || this.flag == '0' 
			|| this.flag == '1' || this.flag == '3') { // 隐患详情
				this.getDetail4YH_XQ()
			} else if (this.flag === 'JC_XQ') { // 检查详情
				this.getDetail4JC_XQ()
				
			} else if (this.flag === 'ADD') { // 新增，调用模板详情方法
				this.getDetail4Template()
			}
		},
		watch: {
			checkData: {
				handler(newVal) {
					const snapshot = JSON.parse(JSON.stringify(newVal));
					console.log('全量变化:', snapshot);
					this.noCount = countSelectedNo(snapshot); // selected=no 的个数
					// this.totalItems = getTotalCheckListItems(newVal); // checkList 子元素总数
					this.notNullCount = countSelectedNotNull(snapshot); // selected 不为 null 的个数
				},
				deep: true
			}
		},
		methods: {
			validRequired(){
				if(this.flag == 'JC_XQ'){ // 检查详情，不参与下一页校验
					this.checkPageIndex++;
					return true
				}
				const currentPageData = this.checkData[this.checkPageIndex];
				const errorRows = currentPageData.gqCheckItemList.filter((item)=>{
					console.log(item)
					if(item.itemAnswer === 2){
						return !item.description || !item.photos?.length || !item.deadlineDays
					}
					return false
				})
				console.log('errorRows.length', errorRows.length)
				if(errorRows.length){
					vant.Dialog.alert({
						title: '信息提示',
						message: '请填写完整信息，必填项不可为空',
					  })
					  return
				}
			
				this.checkPageIndex++;
			},
			getOriginMatchedItemById(id) {
				const result = this.originCheckData[this.checkPageIndex]['gqCheckItemList'].find(item =>
					item.id === id) || []
				return JSON.parse(JSON.stringify(result))
			},
			// 处理单选变化
			handleSelectionChange(val, item, index) {
				console.log(val, item, '数据改变了前')
				const newItem = this.getOriginMatchedItemById(item.id)
				console.log(val, newItem, '数据改变了。。。。newItem')
				newItem.itemAnswer = val
				// console.log(this.checkData[this.checkPageIndex]['gqCheckItemList'])
				this.$set(this.checkData[this.checkPageIndex]['gqCheckItemList'], index, JSON.parse(JSON
					.stringify(newItem)));
				console.log(val, this.checkData[this.checkPageIndex]['gqCheckItemList'][index], '数据改变了后',
					index)
			},
			// 文件上传处理
			handleFileUpload(file) {
				console.log('上传文件:', file);
				// 此处可添加实际文件上传逻辑
			},
			// 整改天数确认
			handleDeadlineConfirm(event, item) {
				console.log('select选择', event.target.value)
				const value = event.target.value;
				if (value) {
					const days = parseInt(value);
					item.deadlineDays = days;
					const deadlineDate = new Date();
					deadlineDate.setDate(deadlineDate.getDate() + days);
					item.deadlineDate = this.formatDate(deadlineDate);
				}
				// this.showDeadlinePicker = false;
			},
			// 日期格式化
			formatDate(date) {
				return `${date.getFullYear()}-${(date.getMonth() + 1).toString().padStart(2, '0')}-${date.getDate().toString().padStart(2, '0')}`;
			},
			getDetail4Template() { // 安全检查模板初始化
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				setTimeout(() => {
				  http2.post(
				    {
				      serviceId: API_KEY_MAP['no-page']['id'],
				      interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
				      interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
				      reqParams: {
				       sign: 5,
				      },
				    },
				    (res) => {
				      console.log('接口回调数据1111template', res)
				      if (!res) { // 中台返回为undefined 重新请求
				      	vant.Toast.clear()
				      	setTimeout(() => {
				      		// this.getDetail4Template()
				      	}, 0);
				      	return
				      }
				      if (res) {
				      	// console.log('接口回调数据', JSON.parse(res))
				      	setTimeout(() => {
				      		this.$nextTick(() => {
				      			vant.Toast.clear()
				      		})
				      	}, 0);
				      	var result = JSON.parse(res)
				      	this.checkDate = result.data.checkDate // 检查日期
				      	this.checkPeopleName = result.data.checkPeopleName // 检查人员
				      	this.rectificationDeadline = result.data.rectificationDeadline // 整改截止日期
				      	this.reviewDate = result.data.reviewDate // 隐患审核日期
				      	this.reviewRecord = result.data.reviewRecord
				      	this.totalItems = result.itemAllCount
				      		// 表单数据
				      		this.checkData = JSON.parse(JSON.stringify(result.data.gqCheckTypeList))
				      	this.originCheckData = JSON.parse(JSON.stringify(result.data.gqCheckTypeList))
						countSelectedNo(this.originCheckData);
						countSelectedNotNull(this.originCheckData)
						
				      }
				    }
				  )
				}, 0)
			},
			getDetail4YH_XQ() { // 隐患详情
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["no-page"]['id'],
					interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
					reqParams: {
						 sign: 4, // 隐患详情
						"hdId": this.id,
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDetail4YH_XQ()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.checkDate = result.checkDate // 检查日期
						this.checkPeopleName = result.checkPeopleName // 检查人员
						this.rectificationDeadline = result.rectificationDeadline // 整改截止日期
						this.reviewDate = result.reviewDate // 隐患审核日期
						this.reviewRecord = result.reviewRecord

						// 表单数据
						this.checkData = result.data
					}
				})

			},
			getDetail4JC_XQ() { // 检查单详情
			console.log('jiancha详情')
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				setTimeout(() => {
				  http2.post(
				    {
				      serviceId: API_KEY_MAP['no-page']['id'],
				      interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
				      interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
				      reqParams: {
				        sign: 2,
				        "recordId": this.id,
				      },
				    },
				    (res) => {
			
				      if (res) {
						  setTimeout(() => {
						  	this.$nextTick(() => {
						  		vant.Toast.clear()
						  	})
						  }, 0);
				        console.log('接口回调数据检查详情', JSON.parse(res))
				        // setTimeout(() => {
				        // 	this.$nextTick(() => {
				        // 		vant.Toast.clear()
				        // 	})
				        // }, 0);
						var result = JSON.parse(res)
				        this.checkDate = result.data.checkTime // 检查日期
				        this.checkPeopleName = result.data.checkPeopleName // 检查人员
				        this.checkData = result.data.gqCheckTypeList
				        this.noCount = result.data.hiddenCount
				        this.notNullCount = result.data.notRectifiedCount
				        this.totalItems = result.itemAllCount
						
						// 表单数据
						this.originCheckData = JSON.parse(JSON.stringify(result.data.gqCheckTypeList))
						countSelectedNo(this.originCheckData);
						countSelectedNotNull(this.originCheckData)
						
				      }
				    }
				  )
				}, 0)
			},
			add4DZG_XQ() {
				console.log('整改图片', this.checkData[0]['gqCheckItemList'][0].photos)
				if (!this.checkData[0]['gqCheckItemList'][0].photos.length) {
					vant.Dialog.alert({
						message: '请上传整改图片',
					})
					return;
				}
				vant.Toast.loading({
					message: '正在处理...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["no-page"]['id'],
					interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
					reqParams: {
						 sign: 7,
						"hdId": this.id,
						"photos": this.checkData[0]['gqCheckItemList'][0].photos,
					}
				}, (res, type) => {
					if (!res && !type) { // 如果是中台接口返回为undefined，则重新发起请求
						vant.Toast.clear()
						setTimeout(() => {
							this.add4DZG_XQ()
						}, 0);
						return
					}
					if (res) {
						console.log('添加结果', res)
						vant.Toast({
							message: '操作成功',
						})
						// history.back()
						gemhoUtil.navigatePage(this.pageName + '.html', '操作完成,跳转中...')
					}
				})
			},
			add4DSH_XQ(auditStatus) { // 隐患详情 审核通过或拒绝
				vant.Toast.loading({
					message: '正在处理...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["no-page"]['id'],
					interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
					reqParams: {
						 sign: 8,
						"hdId": this.id,
						auditStatus
					}
				}, (res, type) => {
					if (!res && !type) { // 如果是中台接口返回为undefined，则重新发起请求
						vant.Toast.clear()
						setTimeout(() => {
							this.add4DSH_XQ()
						}, 0);
						return
					}
					if (res) {
						console.log('添加结果', res)
						vant.Toast({
							message: '操作成功',
						})
						// history.back()
						gemhoUtil.navigatePage(this.pageName + '.html', '操作完成,跳转中...')
					}
				})
			},
			add4JC_XQ() {
				var reqParam = {
					"merId": this.merId,
					"gqCheckTypeList": this.checkData,
				}
				// var url = "/gq/checkRecord/safeCheckRecord"

				http3.post('/gq/checkRecord/safeCheckRecord', reqParam).then((res) => {
					console.log('添加结果', res)
					vant.Toast({
						message: '操作成功',
					})
					gemhoUtil.navigatePage(this.pageName + '.html', '操作完成,跳转中...')
				})
			}
		}
	});
}