/**
 * author: dabao
 */
var VUE = null
window.addEventListener('load', function () {
  VUE = new Vue({
    el: '#app',
    data() {
      return {
        merName: '',
        value: '',
        list: [],
        loading: false,
        finished: false,
        page: 0,
        size: 9999,
        total: 0,
      }
    },
    mounted() {
      this.getList()
    },
    methods: {
      onSearch() {
        console.log('xxxx', this.merName)
		this.getList()
		
      },
      viewDetail(itme) {
        let param = {
          merId: itme.id,
          merName: itme.merName,
          smallPlaceTypeName: itme.smallPlaceTypeName,
          pageName: '_shanghu_list',
        }
        let url = gemhoUtil.setParameter('_checkrecord.html', param)
        gemhoUtil.navigatePage(url, '跳转中...')
      },
      getList() {
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
        setTimeout(() => {
          http2.post(
            {
              serviceId: API_KEY_MAP['page']['id'],
              interfacePublicKey: API_KEY_MAP['page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
              reqParams: {
                sign: 10,
                pageNum: this.page++, // 每次请求增加下一页
                pageSize: this.size,
                sort: 'lawId,desc',
				merName: this.merName || '',
              },
            },
            (res) => {
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  // this.getList()
                }, 0)
                return
              }
              if (res) {
                // console.log('接口回调数据', JSON.parse(res))

                var result = JSON.parse(res)

                this.list = result.data

                // this.total = result.totalElements

                if (this.page * this.size >= this.total) {
                  this.finished = true // 下滑不在刷新数据
                }
              }
              this.loading = false
              setTimeout(() => {
                this.$nextTick(() => {
                  vant.Toast.clear()
                })
              }, 0)
              this.$nextTick(() => {
                // 滚动条跳转位置
                window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'))
              })
            }
          )
        }, 0)
      },
    },
  })
})
