/**
 * author: dabao
 * date: 2024-03-15
 * description: 商户首页
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				// 新增子Tab数据
				subActiveTab: 0,
				hazardList: [{
						id: 1,
						description: '消防通道被货物堵塞，存在严重安全隐患',
						status: '待审核',
						date: '2024-03-15',
						shop: 'XX餐饮店',
						type: 2
					},
					{
						id: 2,
						description: '消防通道被货物堵塞，存在严重安全隐患',
						status: '待整改',
						date: '2024-03-15',
						shop: 'XX餐饮店',
						type: 2
					},
					// 更多示例数据...
				],
				activeTab: 0,
				showTimePicker: false,
				// 新增以下数据
				showTypePicker: false,
				typeOptions: ['小餐饮', '酒店', '商场', '学校', '医疗机构'],
				formData: {
					principal: '',
					phone: '',
					area: '',
					businessHours: '',
					type: '', // 新增类型字段
				},
				checkList: [{
						id: 1,
						date: '2024-03-15',
						result: '合格'
					},
					{
						id: 2,
						date: '2024-03-14',
						result: '不合格'
					}
				]
			}
		},
		computed: {
			filteredHazards() {
				const statusMap = ['全部', '待审核', '待整改', '已整改'];
				return this.hazardList.filter(item =>
					this.subActiveTab === 0 ? true : item.status === statusMap[this.subActiveTab]
				);
			}
		},
		methods: {
			navTo(url){
				// gemhoUtil.nav2asd(url)
				gemhoUtil.navigatePage(`_${url}.html`)
			},
			// 新增选择确认方法
			onConfirmType(value) {
				this.formData.type = value;
				this.showTypePicker = false;
			},
			onConfirmTime(time) {
				this.formData.businessHours = time;
				this.showTimePicker = false;
			},
			statusTagType(status) {
				const types = {
					'待审核': 'warning',
					'待整改': 'primary',
					'已整改': 'success',
					'整改逾期': 'danger',
				};
				return types[status] || '';
			},
			viewDetail(item) {
				console.log('查看详情:', id);
				// 这里添加跳转逻辑
				if(item.status == '01'){ // 待审核
					this.navTo('check_info', item.id)
					// gemhoUtil.navigatePage(`_${url}.html`)		
				}
			}
		}
	});

})