window.onload = function () {
  // 在页面加载完成后执行
  // 执行你的代码
  const currentDate = gemhoUtil.getTargetDateYM()
  new Vue({
    el: '#app',
    data() {
      return {
        showPopup4completionDate: false,
        // 控制日期选择器弹窗的显示与隐藏
        showPicker: false,
        // 存储选择的日期
        selectedDate: currentDate, // '', // gemhoUtil.formatDate(new Date(value)),
        //显示的日期
        showDate: currentDate,
        // 日期选择的最小范围，这里设置为当前日期的前 10 年
        minDate: new Date(new Date().getFullYear() - 10, 0),
        // 日期选择的最大范围，这里设置为当前日期的后 10 年
        maxDate: new Date(new Date().getFullYear() + 10, 11),
        checkModules: [
          {
            intro: '提交检查反馈',
          },
          {
            intro: '查看检查历史记录',
          },
          {
            intro: '提交检查反馈',
          },
          {
            intro: '下载检查报告',
          },
          {
            intro: '查看隐患详情',
          },
          {
            intro: '设置检查提醒',
          },
        ],
        userInfo: {
          userType: 'sj1', // 登录用户type
          userType: 'consumers', // 登录用户type
          userId: '1', // 登录用户id
          userName: '张三', // 登录用户name
          deptId: '1', // 登录用户部门id
          deptName: '部门1', // 登录用户部门name
          safeLevel: '0', //0:绿、1:黄、2:红
          role: 'dudao',
          roleName: '',
        },
        // 登录用户type
        defaultMenuList: [
          {
            className: 'saoma',
            title: '扫码检查',
            remark: '',
            navTo: false,
          },
          {
            className: 'jiancha',
            title: '检查记录',
            remark: '',
            navTo: 'checkrecord',
          },
          {
            className: 'yinhuan',
            title: '隐患审核',
            remark: '',
            navTo: 'yh_check',
          },
          {
            className: 'yinhuan',
            title: '隐患整改',
            remark: '',
            navTo: 'yh_check',
          },
          {
            className: 'shangjia',
            title: '商家信息',
            remark: '',
            navTo: 'shanghu_detail-edit',
          },
          {
            className: 'zicha',
            title: '安全自查',
            remark: '',
            navTo: 'check_info',
          },
        ],
        // 修改默认菜单结构为最小化配置
        menuList: [],
        // 初始化为空数组，等待接口数据填充
        userData: {
          checkCount: 0, //检查数
          checkSelfCount: 0, //自查数
          hiddenCount: 0, //隐患数
          hiddenNoReCount: 0, //未整改数
        },
        page: 1, // 页码
        size: 10, // 每页显示的数量
        accessType: 'manage', // 访问类型  shop商家 saoma 扫码 manage 管理
      }
    },
    mounted() {
      // 在组件挂载后执行
      // 调用你的方法
      this.init()
    },
    computed: {},
    methods: {
      scanCode(toData) {
        if (toData === false) {
          lightAppJssdk.device.scan({
            success: function (data) {
              // 获取到data为二维码的url路径，从这里取请求参数，商户id，在下面跳转本地系统路径
              // alert('扫码成功'+JSON.stringify(data))
              const strUrl = new URL(data);
              const param = {
                merId: strUrl.searchParams.get('merId'),
                accessType: strUrl.searchParams.get('accessType')
              };
              // location.href = 'shanghu_home.html'
              // let param = {
              //   accessType: 'saoma',
              //   merId: data,
              // }
              let url = gemhoUtil.setParameter(`./src/_shanghu_home.html`, param)
              gemhoUtil.navigatePage(url, '跳转中...')
              //成功回调
            },
            fail: function (data) {
              //错误返回
              alert('扫码失败')
            },
          })
        } else {
          // if (this.userInfo.userType === 'shop' && toData === 'checkrecord') {
          //   toData = 'checkrecord'
          // } else {
          //   toData = 'shanghu_list'
          // }
          let param = {
            accessType: this.accessType,
            merId: this.userInfo.merId,
            unitName: this.userInfo.unitName,
            smallPlaceTypeName: this.userInfo.smallPlaceTypeName,
          }
          if (this.userInfo.userType === 'shop') {
            param = {
              ...param,
              accessType: 'shop',
            }
            if (toData == 'check_info') {
              param = {
                ...param,

                accessType: 'shop',
                flag: 'ADD',
                pageName: '../home',
              }
            }
          }
          let url = gemhoUtil.setParameter(`src/_${toData}.html`, param)
          gemhoUtil.navigatePage(url, '跳转中...')
          // gemhoUtil.navigatePage(`src/_${toData}.html`)
        }
      },
      navTo(url) {
        // gemhoUtil.nav2asd(url)
      },
      gotoPage(stringifyUrl) {
        let url = gemhoUtil.setParameter(`src/_${stringifyUrl}.html`)
        gemhoUtil.navigatePage(url, '跳转中...')
      },
      init() {
        // 在组件挂载后执行
        // 调用你的方法
        this.getUserInfo()
        this.getUserData()
      },
      showPopup() {
        this['showPopup4completionDate'] = true
      },
      confirm4completionDate(value) {
        this.selectedDate = gemhoUtil.getTargetDateYMByPara(value)
        this.showDate = gemhoUtil.getTargetDateYMByPara(value)
        this.showPopup4completionDate = false
        this.getUserData()
      },

      // 格式化日期显示的函数，根据需要自定义
      needData(type, val) {
        if (type === 'year') {
          return `${val}`
        } else if (type === 'month') {
          return `${val}`
        }
        return val
      },
      // 取消选择日期时的回调函数
      onCancel() {
        this.showPicker = false
      },
      getUserInfo() {
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
        setTimeout(() => {
          http2.post(
            {
              serviceId: API_KEY_MAP['no-page']['id'],
              interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
              reqParams: {
                sign: 9,
                pageNum: this.page++, // 每次请求增加下一页
                pageSize: this.size,
                sort: 'lawId,desc',
              },
            },
            (res) => {
              console.log(JSON.parse(res), 'JSON.parse(res)')
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  // this.getList()
                }, 0)
                return
              }
              if (res) {
                var result = JSON.parse(res)
                if (result.code !== 200 && result.data == null) {
                  return
                }
                this.userInfo = {
                  userType: result.data.roleDeptNameVo.userType, // 登录用户type
                  userId: '1', // 登录用户id
                  userName: '张三', // 登录用户name
                  deptId: '1', // 登录用户部门id
                  safeLevel: result.data.merchantInfoNumVo?.safeLevel, //0:绿、1:黄、2:红
                  deptName: result.data.roleDeptNameVo.deptName, // 登录用户部门name
                  businessAddress:
                    result.data.merchantInfoNumVo?.businessAddress, //
                  smallPlaceTypeName:
                    result.data.merchantInfoNumVo?.smallPlaceTypeName, //
                  unitName: result.data.merchantInfoNumVo?.unitName, //
                  role: 'dudao',
                  roleName: result.data.roleDeptNameVo?.roleName,
                  merId: result.data.merchantInfoNumVo?.id, //
                }
                gemhoUtil.setCookie('userType', this.userInfo.userType)

                /* if (this.userInfo.userType === 'consumers') { // 2025年5月14日新增消费者逻辑
                  // 根据url地址的merid获取商户信息
                  if (gemhoUtil.getParameter('merId')) { // 消费者直接在爱山东扫商户码进入首页
                    // this.getMerInfo()
                    param = {
                      merId: gemhoUtil.getParameter('merId'),
                      pageName: 'src/_consumer_home',
                    }
                    let url = gemhoUtil.setParameter(`${param.pageName}.html`, param)
                    gemhoUtil.navigatePage(url, '跳转中...')
                    return
                  } else { // 消费者不扫码后，直接退出到爱山东首页。（用户直接在爱山东点击应用进入首页）
                    vant.Dialog.alert({
                      title: '信息提示',
                      message: '请扫描商户码访问~',
                    }).then(() => { // 关闭当前访问页面回到爱山东
                      lightAppJssdk.navigation.close({
                        success: function (data) { },
                        fail: function (data) { },
                      })
                    });
                  }

                  return
                } else */
				if (this.userInfo.userType === 'shop') {
                  this.defaultMenuList[1].navTo = 'checkrecord'
                } else {
                  this.defaultMenuList[1].navTo = 'shanghu_list'
                }
                // 生成最终菜单列表
                this.menuList = (result.data.modules || []).map(
                  (moduleItem) => ({
                    ...(this.defaultMenuList.find(
                      (d) => d.title === moduleItem.title
                    ) || {}),
                    ...moduleItem,
                    remark: moduleItem.remark || '',
                  })
                )
              }
              setTimeout(() => {
                this.$nextTick(() => {
                  vant.Toast.clear()
                })
              }, 0)
            }
          )
        }, 0)
      },
      // 获取用户数据的方法
      getUserData() {
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
        setTimeout(() => {
          http2.post(
            {
              serviceId: API_KEY_MAP['no-page']['id'],
              interfacePublicKey: API_KEY_MAP['no-page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['no-page']['privateKey'],
              reqParams: {
                sign: 6,
                pageNum: this.page++, // 每次请求增加下一页
                pageSize: this.size,
                date: this.selectedDate,
                sort: 'lawId,desc',
                merId: gemhoUtil.getParameter('merId'),
              },
            },
            (res) => {
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  // this.getList()
                }, 0)
                return
              }
              if (res) {
                var result = JSON.parse(res)
                this.userData = result.data
              }
            }
          )
        }, 0)
      },
    },
    //过滤器
    filters: {
      //格式化日期显示的函数，根据需要自定义
      formatterData(val) {
        if (!val) return ''
        const [year, month] = val.split('-')
        return `${year}年${month}月`
      },
    },

  })
}
