/** axios封装
 * 请求拦截、相应拦截、错误统一处理
 */
// 环境的切换
axios.defaults.baseURL = 'http://192.168.2.37:8080'
axios.defaults.timeout = 50000
// post请求头
// axios.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8'
axios.defaults.headers.post['Content-Type'] = 'application/json'
// axios.defaults.headers.common['Authorization'] = gemhoUtil.getCookie('token')


// // 消费者token
// axios.defaults.headers.common['Authorization'] =
//   'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiLmtojotLnogIUiLCJsb2dpbl91c2VyX2tleSI6ImExNWIwMDNjLWRlYWItNGU2MC04ODg4LTJiODNjMzVkNDUzNSJ9.l6gHzFX-U5rKGJ7zoDA4jMBIxkhVgCjWr5ynFg1DR6xspM9Ls6raTxyEo2Kr61UbG2UD6P2kN63vF_U8nX8afg'


// 商户token
axios.defaults.headers.common['Authorization'] =
  'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiIxMzg2MzE1OTk4NyIsImxvZ2luX3VzZXJfa2V5IjoiMDc1ZWVkOGUtYjZjNC00OTE3LWJlYjYtY2RhOTBmYWY2YTkwIn0.7IcT8J7AGWR7vlesikjZvDYYvSY46TKIU2F41g8V7z6naxJQOlOKt-IXTzTo2QmlSF5Eo7hbxfTy7OJxdT4MWw'

// admin账号token
// axios.defaults.headers.common['Authorization'] =
// 'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJhZG1pbiIsImxvZ2luX3VzZXJfa2V5IjoiNTljMWVhMTMtODNmYy00OWI2LWI5YzMtM2VkNzliODFhZjg4In0.XHl0IpagNwLJBqW_s2n6Kzhs9eY-TrMUBfAO8oeikYRUH72eshEXwMsTyTWgVnX_okY4tuB4U124AeF6EO_qiQ'


// 请求拦截器

axios.interceptors.request.use((config) => {
  vant.Toast.loading({
    message: '加载中...',
    forbidClick: true,
    loadingType: 'spinner',
  })
  return config
})

// 响应拦截器
axios.interceptors.response.use(
  (res) => {
    // 成功的响应数据  服务器的相关的数据返回来之后，响应拦截器能够检测到，可以做一些事

    vant.Toast.clear()
    return res
  },
  (error) => {
    // 响应失败的时候的回调函数
    return Promise.reject(new Error(error))
  }
)

var http2 = {
  get: function (url, params) {
    return new Promise((resolve, reject) => {
      axios
        .get(url, {
          params: params,
        })
        .then((res) => {
          resolve(res.data)
        })
        .catch((err) => {
          reject(err.data)
        })
    })
  },
  post: function (
    { serviceId, interfacePublicKey, interfacePrivateKey, reqParams },
    fn
  ) {
    return new Promise((resolve, reject) => {
      axios
        .post('/gq/asd/common', {
          serviceId,
          interfacePublicKey,
          interfacePrivateKey,
          reqParams,
        })
        .then((res) => {
          // res.data = JSON.parse(res.data)
          let response = res.data.data
          if (response.statusCode >= 300 || response.status >= 300) {
            vant.Dialog.alert({
              title: '信息提示',
              message: response.message,
            })
            // 保持与http2.post相同的错误处理逻辑
            typeof fn === 'function' && fn(null)
            reject(response)
            return
          }
          typeof fn === 'function' && fn(response)
          resolve(response)
        })
        .catch((err) => {
          reject(err.response?.data || err.message)
        })
    })
  },
  postFile: function (url, params) {
    return new Promise((resolve, reject) => {
      axios({
        url,
        method: 'post',
        data: params,
        headers: {
          'Content-Type': 'application/json', // 'multipart/form-data;',
          Authorization: localStorage.getItem('Authorization'),
        },
      })
        .then((res) => {
          let response = res.data
          if (response.statusCode >= 300 || response.status >= 300) {
            // alert('系统发生错误')
            vant.Dialog.alert({
              title: '信息提示',
              message: response.message,
            })
            return
          }
          resolve(res.data)
        })
        .catch((err) => {
          reject(err.data)
        })
    })
  },
}
