/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				loadFlag: false,
				value: '',
				list: [],
				// loadFlag: false,
				finished: false,
				page: 0,
				size: 9999,
				total: 0
			}
		},
		mounted() {
			this.getList()
		},
		methods: {
			detail(item) {
				gemhoUtil.navigatePage('./yh-list-detail.html?hdId=' + item.hdId + '&type=detail')
			},
			edit(item) {
				gemhoUtil.navigatePage('./yh-list-detail.html?hdId=' + item.hdId + '&type=edit')
			},
			getList() {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				setTimeout(() => {
					http2.post({
						serviceId: API_KEY_MAP["yh-list"]['id'],
						interfacePublicKey: API_KEY_MAP["yh-list"]["publicKey"],
						interfacePrivateKey: API_KEY_MAP["yh-list"]["privateKey"],
						reqParams: {
							page: this.page++, // 每次请求增加下一页
							size: this.size,
							sort: 'hdId,desc',
						}
					}, (res) => {
						if(!res){ // 中台返回为undefined 重新请求
							vant.Toast.clear()
							this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
							setTimeout(() => {
								this.getList()
							}, 0);
							return
						}	
						if (res) {
							var result = JSON.parse(res)
							this.list.push(...result.content);
							this.total = result.totalElements

							if (this.page * this.size >= this.total) {
								this.finished = true; // 下滑不在刷新数据
							}
						}
						this.loadFlag = false
						setTimeout(() => {
							this.$nextTick(()=>{
								vant.Toast.clear()
							})
						}, 0);
						// console.log('响应结束',this.total, this.list.length)
						this.$nextTick(()=>{
							// 滚动条跳转位置
							window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'));
						})
					})
				}, 0)

			}
		},
	});
});