/**
 * author: dabao
 * date: 2024-03-15
 * description: 商户首页
 */


var VUE = null

window.addEventListener("pageshow", (event) => {
	console.log(event, 'event')
	if (event.persisted) { // 从 BF Cache 加载时触发
		location.reload(); // 强制刷新
	}
});

window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				reMark: '',
				title: '',
				userType: gemhoUtil.getCookie('userType'),

				hazardList: [ // 更多示例数据...
				],
				workTypeName: '',
				merId: '',
				merName: '',
				loading: false,
				finished: false,
				page: 1,
				size: 6,
				total: 0,
				reqFlag: false, // 页面列表接口请求flag 防止多次请求
			}
		},
		mounted() {
			this.init() // 获取隐患记录
		},
		methods: {
			markAllAsRead() { // 全部标记为已读
				http2.post({
						serviceId: API_KEY_MAP['submit']['id'],
						interfacePublicKey: API_KEY_MAP['submit']['publicKey'],
						interfacePrivateKey: API_KEY_MAP['submit']['privateKey'],
						reqParams: {
							sign: 36, // post 设置已读
						},
					},
					(res) => {
						if (!res) {
							// 中台返回为undefined 重新请求
							setTimeout(() => {
								this.markAllAsRead()
							}, 0)
							return
						}
						var result = JSON.parse(res)
						if (result && result.code == 200) {
							vant.Toast({
								message: '操作成功',
							})
							
							this.hazardList.forEach(item => {
							  if (item.msgFlag) {
							    this.$set(item, 'msgFlag', false); // 动态添加响应式属性
							  }
							});
						}
					}
				)
			},
			reset() {
				this.page = 1
				this.size = 10
				this.total = 0
				this.hazardList = []
				
				this.loading = false
				this.finished = false
			},
			onSearch() {
				console.log('xxxx', this.title)
				this.init()
			},
			init() {
				this.reset()
				this.getList()
			},
			viewDetail(item) {
				let params = {
					id: item.id || '',
					merId: gemhoUtil.getParameter('merId'),
					pageName: '_tezhongzuoye'
				}
				// 这里添加跳转逻辑
				var pageUrl = '_tezhongzuoye_detail.html' // 安全培训详情页面
				let url = gemhoUtil.setParameter(pageUrl, params)
				gemhoUtil.navigatePage(url, '跳转中...')
			},
			getList() {
				if(this.reqFlag){ // 第一次请求没有结束则不进行下面逻辑
					return
				}
				this.reqFlag = true
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				})
				setTimeout(() => {
					http2.post({
							serviceId: API_KEY_MAP['page']['id'],
							interfacePublicKey: API_KEY_MAP['page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
							reqParams: {
								sign: 32,
								workTypeName: this.workTypeName,
								merName: this.merName,
								pageNum: this.page, // 每次请求增加下一页
								pageSize: this.size,
								sort: 'lawId,desc',
							},
						},
						(res) => {
							if (!res) {
								// 中台返回为undefined 重新请求
								vant.Toast.clear()
								this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
								setTimeout(() => {
									// this.getList()
								}, 0)
								return
							}
							if (res) {
								var result = JSON.parse(res)
								console.log('接口信息', result)
								if (result.code !== 200 && result.data == null) {
									return
								}
								this.hazardList.push(...result.rows)
								this.total = result.total
								if (this.page * this.size >= this.total) {
									this.finished = true // 下滑不在刷新数据
								}else{this.page++}
							}
							this.loading = false
							 this.reqFlag = false
						}
					)
				}, 0)
			},
		}
	});

})