/**
 * author: dabao
 * date: 2024-03-15
 * description: 商户首页
 */
var VUE = null
window.addEventListener("load", function () {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				name:'',
				userType: gemhoUtil.getCookie('userType'),
				shanghuName: '',
				// 新增子Tab数据
				hazardList: [
				  // 更多示例数据...
				],
				activeTab: 0,
				status: '',
				merId: '',
				showSearch: false, // 控制搜索框的显示和隐藏
				// 整改状态 0：待整改 1：已整改 2：待审核 3：整改逾期
				tabList: [
				  { name: '1', title: '常识视频', msgNum: 0, },
				  { name: '2', title: '警示视频', msgNum: 0, },
				  { name: '3', title: '应知应会', msgNum: 0, },
				],
				loading: false,
				finished: false,
				page: 1,
				size: 6,
				total: 0,
				type: '1' ,// 常识视频  2，3
				reqFlag: false, // 页面列表接口请求flag 防止多次请求
			}
		},
		created() {
			let params = gemhoUtil.getUrlParams()
			console.log(params);
			this.merId = params.merId
		},
		mounted() {
			this.init()
		},
		methods: {
			init() {
				this.getList()
			  },
			onSearch() {
			  console.log('xxxx', this.name)
			  this.getList()
			
			},
			reset() {
				this.page = 1
				this.size = 6
				this.total = 0
				this.hazardList = []
				this.loading = false
				this.finished = false
			  },
			getList(){
				if(this.reqFlag){ // 第一次请求没有结束则不进行下面逻辑
					return
				}
				this.reqFlag = true
				 // 这里添加获取数据的逻辑
				 vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				  })
				  setTimeout(() => {
					http2.post(
					  {
						serviceId: API_KEY_MAP['page']['id'],
						interfacePublicKey: API_KEY_MAP['page']['publicKey'],
						interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
						reqParams: {
						  sign: 16,
						  // merId: this.merId ? this.merId : '',
						  safetyName: this.name,
						  pageNum: this.page, // 每次请求增加下一页
						  pageSize: this.size,
						  type: (this.activeTab+1)+''
						},
					  },
					  (res) => {
						if (!res) {
						  // 中台返回为undefined 重新请求
						  vant.Toast.clear()
						  this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
						  setTimeout(() => {
							this.getList()
						  }, 0)
						  return
						}
						if (res) {
						  var result = JSON.parse(res)
						  console.log(result, 'result')
						  this.loading = false; // 加载状态结束
						  this.hazardList.push(...result.rows);
						  this.total = result.total
		  
						  if (this.page * this.size >= this.total) {
							this.finished = true; // 下滑不在刷新数据
						  }else{this.page++}
						}
						this.loading = false
						setTimeout(() => {
						  this.$nextTick(() => {
							vant.Toast.clear()
							this.reqFlag = false
						  })
						}, 0);
		  
					  }
					)
				  }, 0)
			},
			tabChange(title) {
				console.log('tab 切换', this.activeTab)
				
				this.reset()
				this.getList()
			  },
			  init() {
				this.getList()
			  },
			  onSearch() {
				this.reset()
				this.getList()
			  },
			// 新增选择确认方法
			
			viewDetail(item, type) {
				let param = {
					id: item.id,
					pageName: '_anquan_changshi',
				  }
				  let pageName = ''
				  if(item.type === '3'){ // 应知应会 跳转富文本详情
					pageName = '_anquan_changshi-detail-text.html'
				  }else{
					pageName = '_anquan_changshi-detail-video.html'

				  }
				  let url = gemhoUtil.setParameter(pageName, param)
				  console.log(url)
		  
				  gemhoUtil.navigatePage(url, '跳转中...')
			},
		}
	});

})