/**
 * 1：根据商铺id 查询安全检查记录
 * 2：根据记录id 查询详情
 * 	3：隐患列表
	4：隐患详情
	5：查询安全检查模板数据
	6：商家首页按月查询
	9：用户角色可查看的模块
	10：查询用户检查过的商户信息
	11: 查询商户详情信息
	
	跳转逻辑：
	新增检查单，flag=ADD，
	检查单详情，flag=JC_XQ，id=记录id
	待审核隐患，flag=2，id=隐患id
	待整改隐患，flag=0，id=隐患id
	已整改隐患，flag=1，id=隐患id
	整改逾期隐患，flag=3，id=隐患id
	
	
	整改状态 0：待整改 1：已整改 2：待审核 3：整改逾期
	
 */

var VUE = null

window.onload = function () {
	VUE = new Vue({
		el: '#app',
		components: {
		},
		data: {
			userType: gemhoUtil.getCookie('userType'),
			id: '', // 记录id || 隐患id
			merId: '', // 商户id
			pageName: '', // 页面名称(用于记录页面来源，用于操作后返回上一页)
			flag: 'ZG_XQ', // 值为ADD新增、JC_XQ检查详情、ZG_XQ整改详情、YH_XQ隐患详情
			flag: 'ADD',
			// flag: 'JC_XQ',
			// flag: 'YH_XQ',
			checkData: [], // 提交给后端，图片使用vant结构，base64，后端处理，不走爱山东中台。（数据量大！）
			originCheckData: [],
	
			// 外层表单信息
			checkDate: '', // 检查日期
			checkPeopleName: '', // 检查人员
			rectificationDeadline: '', // 整改截止日期
	
			rectificationRecords: [
				/* 示例数据结构，实际从接口获取 */
				{
					rectificationDate: '2024-03-15', // 整改日期
					images: ['/images/rectify-20240315-01.jpg', '/images/rectify-20240315-02.jpg'], // 整改图片路径
					status: 'reject', // 状态：拒绝
					approveDate: '2024-03-16', // 审批日期
					rejectReason: '消防通道堵塞未清理，灭火器过期未更换' // 拒绝原因
				  },
				  
				  // 待审批记录（仅基础信息）
				  {
					rectificationDate: '2024-03-20', // 整改日期
					images: ['/images/rectify-20240320-01.jpg'], // 整改图片路径（单张）
					status: 'pending', // 状态：待审批
					// 待审批状态无需审批日期和拒绝原因
				  },
				  
				  // 审批通过记录（含审批信息）
				  {
					rectificationDate: '2024-03-25', // 整改日期
					images: ['/images/rectify-20240325-01.jpg', '/images/rectify-20240325-02.jpg', '/images/rectify-20240325-03.jpg'], // 三张图片
					status: 'approve', // 状态：通过
					approveDate: '2024-03-26' // 审批日期
				  }
			  ]
		},
		mounted() {
			/**
			 * 调转该_check_info.html页面时需要传递参数
			 * flag : ADD新增、JC_XQ检查详情、ZG_XQ整改详情、YH_XQ隐患详情
			 * id: 记录id || 隐患id
			 * pageName: 页面名称(用于记录页面来源，用于操作后返回上一页)
			 *	隐患状态    0：待整改 1：已整改 2：待审核 3：整改逾期
			 */
			this.pageName = gemhoUtil.getParameter('pageName')
			this.id = gemhoUtil.getParameter('id')

			this.getDetail4YH_XQ()
		},
		watch: {
		},
		methods: {
			
			// 日期格式化
			formatDate(date) {
				return `${date.getFullYear()}-${(date.getMonth() + 1).toString().padStart(2, '0')}-${date.getDate().toString().padStart(2, '0')}`;
			},
			getDetail4YH_XQ() { // 隐患详情
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["no-page"]['id'],
					interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
					reqParams: {
						sign: 4, // 隐患详情
						"hdId": this.id,
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDetail4YH_XQ()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.checkDate = result.checkDate // 检查日期
						this.checkPeopleName = result.checkPeopleName // 检查人员
						this.rectificationDeadline = result.rectificationDeadline // 整改截止日期
						this.reviewDate = result.reviewDate // 隐患审核日期
						this.reviewRecord = result.reviewRecord

						// 表单数据
						this.checkData = result.data
					}
				})

			},
			showImage(list, index) {
				vant.ImagePreview({
					images: list,
					startPosition: index,
					closeable: true,
				});
			},
			
		}
	});
}