/**
 * author: dabao
 * date: 2024-03-15
 * description: 商户首页
 */
var VUE = null
var quill = null
window.addEventListener("load", function () {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				detailInfo: {},
			}
		},
		created() {
		},
		mounted() {
			this.detail()
		},
		methods: {
			detail() { // 隐患详情
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				http2.post({
					serviceId: API_KEY_MAP["no-page"]['id'],
					interfacePublicKey: API_KEY_MAP["no-page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["no-page"]["privateKey"],
					reqParams: {
						sign: 34, // 隐患详情
						workType: gemhoUtil.getParameter('type'),
					}
				}, (res) => {
					if (res) {
						console.log('接口回调数据', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						this.detailInfo = JSON.parse(res).data
						// 初始化编辑器
						quill = new Quill('#editor-container', {
							theme: 'snow', readOnly: true, modules: {
								toolbar: false  // 关键配置：禁用工具栏
							},
						});
						quill.root.innerHTML = this.detailInfo || ''
					}
				})

			},
		}
	});

})