/**
 * author: dabao
 * date: 2024-03-15
 * description: 商户首页
 */
var VUE = null
window.addEventListener("pageshow", (event) => {
	console.log(event, 'event')
	if (event.persisted) { // 从 BF Cache 加载时触发
		location.reload(); // 强制刷新
	}
});
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				reMark:'',
				title: '',
				userType: gemhoUtil.getCookie('userType'),
				tabList4lv1: [],
				tabList4lv2: [],
				// 新增子Tab数据
				subActiveTab: 0,
				hazardList: [ // 更多示例数据...
				],
				activeTab: 0,
				showTimePicker: false,
				// 新增以下数据
				showTypePicker: false,
				formData: {
					principal: '',
					phone: '',
					area: '',
					businessHours: '',
					type: '', // 新增类型字段
				},
				checkList: [{
						id: 1,
						date: '2024-03-15',
						result: '合格'
					},
					{
						id: 2,
						date: '2024-03-14',
						result: '不合格'
					}
				],
				merId: '',
				merName: '',
				loading: false,
				finished: false,
				page: 1,
				size: 6,
				total: 0,
				reqFlag: false, // 页面列表接口请求flag 防止多次请求
			}
		},
		mounted() {
			let params = gemhoUtil.getUrlParams()
			console.log(params);
			this.init() // 获取隐患记录
			this.getDict4tab1()
			this.getDict4tab2()
		},
		methods: {
			getDict4tab1() {
				http2.post({
					serviceId: API_KEY_MAP["page"]['id'],
					interfacePublicKey: API_KEY_MAP["page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["page"]["privateKey"],
					reqParams: {
						page: 1,
						size: 9999,
						sign: 15,
						dictType: 'training_exercise_type'
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDict4businessType()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据=生产经营类型', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.tabList4lv1 = result.rows

					}
				})
			},
			getDict4tab2() {
				http2.post({
					serviceId: API_KEY_MAP["page"]['id'],
					interfacePublicKey: API_KEY_MAP["page"]["publicKey"],
					interfacePrivateKey: API_KEY_MAP["page"]["privateKey"],
					reqParams: {
						page: 1,
						size: 9999,
						sign: 15,
						dictType: 'safety_training_category'
					}
				}, (res) => {
					if (!res) { // 中台返回为undefined 重新请求
						vant.Toast.clear()
						setTimeout(() => {
							this.getDict4businessType()
						}, 0);
						return
					}
					if (res) {
						console.log('接口回调数据=生产经营类型', JSON.parse(res))
						setTimeout(() => {
							this.$nextTick(() => {
								vant.Toast.clear()
							})
						}, 0);
						var result = JSON.parse(res)
						this.tabList4lv2 = result.rows

					}
				})
			},
			reset() {
				this.page = 1
				this.size = 10
				this.total = 0
				this.hazardList = []
				this.loading = false
				this.finished = false
			},
			clickTab() {
				this.init()
				console.log('activeTab', this.activeTab)
			},
			clickSubTab() {
				this.init()
				console.log('activeSubTab', this.subActiveTab)
			},
			onSearch() {
				console.log('xxxx', this.title)
				this.init()
			},
			init() {
				this.reset()
				this.getList()
			},
			// 新增选择确认方法
			onConfirmType(value) {
				this.formData.type = value;
				this.showTypePicker = false;
			},
			onConfirmTime(time) {
				this.formData.businessHours = time;
				this.showTimePicker = false;
			},
			viewDetail(item) {
				let params = {
					id: item.id ||'',
					merId: gemhoUtil.getParameter('merId'),
					pageName: '_peixun_yanlian'
				}
				// 这里添加跳转逻辑
				var pageUrl = '_peixun_yanlian_detail-anquan.html' // 安全培训详情页面
				console.log(this.activeTab==1, 'accccc')
				if (this.activeTab == 1) { // 跳转应急演练详情
					pageUrl = '_peixun_yanlian_detail-yingji.html'
				}
				let url = gemhoUtil.setParameter(pageUrl, params)
				gemhoUtil.navigatePage(url, '跳转中...')
			},
			getList() {
				if(this.reqFlag){ // 第一次请求没有结束则不进行下面逻辑
					return
				}
				this.reqFlag = true
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				})
				setTimeout(() => {
					http2.post({
							serviceId: API_KEY_MAP['page']['id'],
							interfacePublicKey: API_KEY_MAP['page']['publicKey'],
							interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
							reqParams: {
								sign: 30,
								title: this.title,
								merName: this.merName,
								exerciseType: this.activeTab + 1,
								safetyTrainingType: this.activeTab == 1 ? 0 : this.subActiveTab,
								pageNum: this.page, // 每次请求增加下一页
								pageSize: this.size,
								sort: 'lawId,desc',
								
							},
						},
						(res) => {
							if (!res) {
								// 中台返回为undefined 重新请求
								vant.Toast.clear()
								this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
								setTimeout(() => {
									// this.getList()
								}, 0)
								return
							}
							if (res) {
								var result = JSON.parse(res)
								console.log('接口信息', result)
								if (result.code !== 200 && result.data == null) {
									return
								}
								this.hazardList.push(...result.rows)
								this.reMark = result.reMark
								this.total = result.total
								if (this.page * this.size >= this.total) {
									this.finished = true // 下滑不在刷新数据
								}else{this.page++}
							}
							this.loading = false
							this.reqFlag = false
						}
					)
				}, 0)
			},
		}
	});

})