var VUE = null
window.addEventListener('load', function () {
  VUE = new Vue({
    el: '#app',
    data() {
      return {
        userType: gemhoUtil.getCookie('userType'),
        merName: '',
        // 新增子Tab数据
        activeTab: '1',
        hazardList: [],
        // 新增以下数据
        userInfo: {},
        userData: {
          checkCount: 0, //检查数
          checkSelfCount: 0, //自查数
          hiddenCount: 0, //隐患数
          hiddenNoReCount: 0, //未整改数
        },

        loading: false,
        finished: false,
        page: 1,
        size: 10,
        total: 0,
        merId: null, // 商户id
        unitName: '', // 单位名称
        smallPlaceTypeName: '', // 场所类型
		reqFlag: false, // 页面列表接口请求flag 防止多次请求
      }
    },
    created() {
      let urlParams = gemhoUtil.getUrlParams()
      this.merId = urlParams.merId
      this.unitName = urlParams.unitName
      this.smallPlaceTypeName = urlParams.smallPlaceTypeName
      this.init()
    },
    computed: {},
    methods: {
      reset() {
        this.page = 1
        this.size = 10
        this.total = 0
        this.hazardList = []
		this.loading = false
		this.finished = false
      },
      onSearch() {
        console.log('xxxx', this.merName)
        this.init()
      },
      //初始化页面
      init() {
        this.reset()
        this.getList()
      },
      tabChange() {
        this.init()
      },
      getList() {
		  if(this.reqFlag){ // 第一次请求没有结束则不进行下面逻辑
		  	return
		  }
		  this.reqFlag = true
        // 更多示例数据...
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
        setTimeout(() => {
          http2.post(
            {
              serviceId: API_KEY_MAP['page']['id'],
              interfacePublicKey: API_KEY_MAP['page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
              reqParams: {
                sign: 1,
                type: this.activeTab,
                merId: this.merId,
                pageNum: this.page, // 每次请求增加下一页
                pageSize: this.size,
                sort: 'lawId,desc',
                merName: this.merName,

              },
            },
            (res) => {
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  this.getList()
                }, 0)
                return
              }
              if (res) {
                var result = JSON.parse(res)
                console.log('接口信息', result)
                if (result.code !== 200 && result.data == null) {
                  return
                }
                this.hazardList.push(...result.rows)
                this.total = result.total
                if (this.page * this.size >= this.total) {
                  this.finished = true // 下滑不在刷新数据
                }else{this.page++}
              }
              this.loading = false
              setTimeout(() => {
                this.$nextTick(() => {
                  vant.Toast.clear()
				  this.reqFlag = false
                })
              }, 0)
              this.$nextTick(() => {
                // 滚动条跳转位置
                window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'))
              })
            }
          )
        }, 0)
      },
      viewDetail(id) {
        let urlParams = gemhoUtil.getUrlParams()
        let param = {
          ...urlParams,
          id: id,
          flag: 'JC_XQ',
          pageName: '_checkrecord-all',
        }
        let url = gemhoUtil.setParameter('_check_info.html', param)

        gemhoUtil.navigatePage(url, '跳转中...')
        // 这里添加跳转逻辑
      },
    },
  })
})
