/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				companyName: '',
				value: '',
				list: [],
				loading: false,
				finished: false,
				page: 0,
				size: 9999,
				total: 0
			}
		},
		mounted() {
			this.getList()
		},
		methods: {
			nav(item) {
				// location.href='./law-lv2.html?pid=' + item.id
				gemhoUtil.navigatePage('./law-lv2.html?pid=' + item.id)
			},
			getList() {
				vant.Toast.loading({
					message: '正在加载...',
					forbidClick: true,
					loadingType: 'spinner',
				});
				setTimeout(() => {
					http2.post({
						serviceId: API_KEY_MAP["law-lv"]['id'],
						interfacePublicKey: API_KEY_MAP["law-lv"]["publicKey"],
						interfacePrivateKey: API_KEY_MAP["law-lv"]["privateKey"],
						reqParams: {
							page: this.page++, // 每次请求增加下一页
							size: this.size,
							// sort: 'createTime,desc',
						}
					}, (res) => {
						if(!res){ // 中台返回为undefined 重新请求
							vant.Toast.clear()
							this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
							setTimeout(() => {
								this.getList()
							}, 0);
							return
						}	
						if (res) {
							// console.log('接口回调数据', JSON.parse(res))

							var result = JSON.parse(res)
							this.loading = false; // 加载状态结束
							this.list.push(...result.content);
							this.total = result.totalElements

							if (this.page * this.size >= this.total) {
								this.finished = true; // 下滑不在刷新数据
							}
						}
						this.loading = false
						setTimeout(() => {
							this.$nextTick(()=>{
								vant.Toast.clear()
							})
						}, 0);
						this.$nextTick(()=>{
							// 滚动条跳转位置
							window.scrollTo(0, gemhoUtil.getCookie('scrollPosition'));
						})
					})
				}, 0)
			}
		},
	});
});