/** axios封装
 * 请求拦截、相应拦截、错误统一处理
 */
// 环境的切换
axios.defaults.baseURL = 'http://192.168.3.37:8036'
axios.defaults.timeout = 50000
// post请求头
// axios.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8'
axios.defaults.headers.post['Content-Type'] = 'application/json'
axios.defaults.headers.common['systemId'] = '1'
axios.defaults.headers.common['Authorization'] = localStorage.getItem('Authorization')
// 请求拦截器

axios.interceptors.request.use(config => {
	console.log('request拦截器', config)
	vant.Toast.loading({
		message: '加载中...',
		forbidClick: true,
		loadingType: 'spinner',
	});
	return config
})

// 响应拦截器
axios.interceptors.response.use((res) => {
	// 成功的响应数据  服务器的相关的数据返回来之后，响应拦截器能够检测到，可以做一些事

	vant.Toast.clear()
	return res;
}, (error) => {
	// 响应失败的时候的回调函数
	return Promise.reject(new Error(error))
})


var http = {
	get: function(url, params) {
		return new Promise((resolve, reject) => {
			axios
				.get(url, {
					params: params
				})
				.then(res => {
					resolve(res.data)
				})
				.catch(err => {
					reject(err.data)
				})
		})
	},
	post: function(url, params) {
		return new Promise((resolve, reject) => {
			axios
				.post(url, params)
				.then(res => {
					let response = res.data
					console.log('res.statusCode', response)
					if (response.statusCode >= 300 || response.status >= 300) {
						// alert('系统发生错误')
						vant.Dialog.alert({
							title: '信息提示',
							message: response.message,
						})
						return
					}
					resolve(res.data)
				})
				.catch(err => {
					reject(err.data)
				})
		})
	},
	postFile: function(url, params) {
		return new Promise((resolve, reject) => {
			axios({
					url,
					method: 'post',
					data: params,
					headers: {
						'Content-Type': 'application/json', // 'multipart/form-data;',
						'Authorization': localStorage.getItem('Authorization')
					},
				}).then(res => {
					let response = res.data
					console.log('res.statusCode', response)
					if (response.statusCode >= 300 || response.status >= 300) {
						// alert('系统发生错误')
						vant.Dialog.alert({
							title: '信息提示',
							message: response.message,
						})
						return
					}
					resolve(res.data)
				})
				.catch(err => {
					reject(err.data)
				})
		})
	},
	
}
