(function flexible (window, document) {
  var docEl = document.documentElement
  var dpr = window.devicePixelRatio || 1


// 获取当前值 
const dpr11 = window.devicePixelRatio;
console.log(`设备像素比：${dpr11}`);
function getBrowserInfo() {
  const userAgent = navigator.userAgent.toLowerCase();
  console.log(userAgent)
  let browser = 'Unknown';

  // 主流浏览器判断 
  if (userAgent.includes('edg/')) {
    browser = 'Microsoft Edge';
  } else if (userAgent.includes('chrome')) {
    browser = 'Chrome';
  } else if (userAgent.includes('firefox')) {
    browser = 'Firefox';
  } else if (userAgent.includes('safari')) {
    browser = 'Safari';
  } else if (userAgent.includes('trident') || userAgent.includes('msie')) {
    browser = 'Internet Explorer';
  }

  // 版本号提取（示例：Chrome/120.0.0.0）
  const versionMatch = userAgent.match(/(edg|chrome|firefox|safari|version|rv:)[\s\/:]([\d.]+)/i);
  const version = versionMatch ? versionMatch[2] : 'Unknown';

  return { browser, version };
}

// 打印日志
const browserInfo = getBrowserInfo();
console.log(`浏览器：${browserInfo.browser}，版本：${browserInfo.version}`);


  // adjust body font size
  function setBodyFontSize () {
    if (document.body) {
      document.body.style.fontSize = (12 * dpr) + 'px'
    }
    else {
      document.addEventListener('DOMContentLoaded', setBodyFontSize)
    }
  }
  setBodyFontSize();

  // set 1rem = viewWidth / 7.5  // 使用7.5， 使得在750px的设计稿中，1rem = 100px换算十分方便！！！！！！！！
  function setRemUnit () {
    var rem = docEl.clientWidth / 7.5
	console.log('rem', rem)
    docEl.style.fontSize = rem + 'px'
  }

  setRemUnit()

  // reset rem unit on page resize
  window.addEventListener('resize', setRemUnit)
  window.addEventListener('pageshow', function (e) {
    if (e.persisted) {
      setRemUnit()
    }
  })

  // detect 0.5px supports
  if (dpr >= 2) {
    var fakeBody = document.createElement('body')
    var testElement = document.createElement('div')
    testElement.style.border = '.5px solid transparent'
    fakeBody.appendChild(testElement)
    docEl.appendChild(fakeBody)
    if (testElement.offsetHeight === 1) {
      docEl.classList.add('hairlines')
    }
    docEl.removeChild(fakeBody)
  }
}(window, document))
