var VUE = null
window.addEventListener('load', function () {
  VUE = new Vue({
    // 在原有Vue实例中添加
    el: '#app',
    data() {
      return {
        shanghuName: '',
        // 新增子Tab数据
        hazardList: [
          // 更多示例数据...
        ],
        activeTab: '',
        merId: '',
      }
    },
    computed: {
      filteredHazards() {
        const statusMap = ['全部', '待审核', '待整改', '已整改']
        return this.hazardList.filter((item) =>
          this.activeTab === ''
            ? true
            : item.rectificationStatusName === statusMap[this.activeTab]
        )
      },
    },
    created() {
      let merId = gemhoUtil.getParameter('merId')
      if (merId !== undefined && merId !== null) {
        this.merId = merId
      } else {
        this.merId = ''
      }
      this.init()
    },
    methods: {
      init() {
        this.getHazardList()
      },
      onSearch() {
        console.log('xxxx')
      },
      // 新增选择确认方法
      onConfirmType(value) {
        this.formData.type = value
        this.showTypePicker = false
      },
      statusTagType(status) {
        const types = {
          待审核: 'warning',
          待整改: 'primary',
          已整改: 'success',
          整改逾期: 'danger',
        }
        return types[status] || ''
      },
      viewDetail(item) {
        let param = {
          id: item.id,
          flag: item.rectificationStatus,
          pageName: '_yh_check',
        }
        let url = gemhoUtil.setParameter('_check_info.html', param)
        console.log(url)

        gemhoUtil.navigatePage(url, '跳转中...')
        // 这里添加跳转逻辑
      },
      //获取隐患列表数据
      getHazardList() {
        // http
        //   .get('/gq/hiddenDanger/list?merId=1&status=' + this.activeTab)
        //   .then((res) => {
        //     console.log(res)
        //   })

        // 这里添加获取数据的逻辑
        vant.Toast.loading({
          message: '正在加载...',
          forbidClick: true,
          loadingType: 'spinner',
        })
        setTimeout(() => {
          http2.post(
            {
              serviceId: API_KEY_MAP['page']['id'],
              interfacePublicKey: API_KEY_MAP['page']['publicKey'],
              interfacePrivateKey: API_KEY_MAP['page']['privateKey'],
              reqParams: {
                sign: 3,
                // merId: this.merId ? this.merId : '',
                status: this.activeTab,
                pageNum: this.page++, // 每次请求增加下一页
                pageSize: this.size,
                sort: 'lawId,desc',
              },
            },
            (res) => {
              if (!res) {
                // 中台返回为undefined 重新请求
                vant.Toast.clear()
                this.page = this.page - 1 // 重新请求后，分页数恢复上一次请求的值
                setTimeout(() => {
                  // this.getList()
                }, 0)
                return
              }
              if (res) {
                var result = JSON.parse(res)
                this.hazardList = result.rows
                console.log(result)
              }
            }
          )
        }, 0)
      },
    },
  })
})
