/** axios封装
 * 请求拦截、相应拦截、错误统一处理
 */
const BASE_URL = 'http://192.168.2.37:8080'
// 环境的切换
axios.defaults.baseURL = BASE_URL
axios.defaults.timeout = 50000
// post请求头
// axios.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8'
axios.defaults.headers.post['Content-Type'] = 'application/json'
// axios.defaults.headers.common['Authorization'] = gemhoUtil.getCookie('token')


// // 消费者token
// axios.defaults.headers.common['Authorization'] =
//   'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiLmtojotLnogIUiLCJsb2dpbl91c2VyX2tleSI6ImExNWIwMDNjLWRlYWItNGU2MC04ODg4LTJiODNjMzVkNDUzNSJ9.l6gHzFX-U5rKGJ7zoDA4jMBIxkhVgCjWr5ynFg1DR6xspM9Ls6raTxyEo2Kr61UbG2UD6P2kN63vF_U8nX8afg'


// 商户token
axios.defaults.headers.common['Authorization'] =
  'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiIxNTcyMTAzMTg4NiIsImxvZ2luX3VzZXJfa2V5IjoiNGJjY2JjYzUtNmY0Yy00ZDhlLWJiYzEtZjYzMzVlZDBlZTgwIn0.j3jEfHzeu3kklm60kKCirwwyKaWD51ABicOzxEnuFOfGe63FFqYOQ122ojAhukbInnKj4try3DjrST6wNDVjVQ'

// 凯丽
//  axios.defaults.headers.common['Authorization'] =
// 'Bearer eyJhbGciOiJlUzUxMiJ9.eyJzdWlioilxNZ92MZAzMDl00SlslmxyZ2luX3VzZXJfa2V5ljoiMEONTM1NzktNTJiMSO0N2QwLTkzNmEtMmViNWFhYzMzMTI1In0.EG_EwS7xS1jgi29Ly7WXOJBCW4DcAyOtLD4he06sV8b4i70kknNQqVAx063NpcDa5kmTFdZ6zEfPHYPfVR4dEO'

// admin账号token
// axios.defaults.headers.common['Authorization'] =
// 'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJhZG1pbiIsImxvZ2luX3VzZXJfa2V5IjoiOTFmMDY4MGYtODA0My00ZTE3LTk4YmUtOGI2NWM0MzI2NGZiIn0.ygF-ObL1f-ZirqG6m7Vrrs_dXLVz-zLEcLMxUP1XVoW2Dek86THn07tzZHTMCgT5ufPNjSSGkaV9Ii4SCZ3qtw'

// wgy账号token
// axios.defaults.headers.common['Authorization'] =
// 'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiLlrZnmgJ3lv40iLCJsb2dpbl91c2VyX2tleSI6ImU0Y2Q2YzQ2LWEyMTAtNGIyMi1hZjAxLTliNjFiMWUyMzcxZiJ9.6IYwYIgsCV2RnnxOrtphRJIcko05AVlqyYGba3KuYE9NzKJlXcgOI-1C0tjXUg2YkJDl1YVDzLKntXEwoUSjCw'
// axios.defaults.headers.common['Authorization'] =
//   'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiIxNTcyMTAzMTg4NiIsImxvZ2luX3VzZXJfa2V5IjoiNGJjY2JjYzUtNmY0Yy00ZDhlLWJiYzEtZjYzMzVlZDBlZTgwIn0.j3jEfHzeu3kklm60kKCirwwyKaWD51ABicOzxEnuFOfGe63FFqYOQ122ojAhukbInnKj4try3DjrST6wNDVjVQ'

// admin账号token
// axios.defaults.headers.common['Authorization'] =
// 'Bearer eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJhZG1pbiIsImxvZ2luX3VzZXJfa2V5IjoiOTEyODc0N2ItNGE4NC00MWRjLTg0ZGUtZTY1ODNkMzBiNDcwIn0.w_JRlifng-sUQqvGnuRFH5-wiL-1tfwI1cF7E97gjaOZ37bvRQld3120Myf9MYqLtVHUVX_vhlcBj7Kmg9exZw'


// 请求拦截器

axios.interceptors.request.use((config) => {
  vant.Toast.loading({
    message: '加载中...',
    forbidClick: true,
    loadingType: 'spinner',
  })
  return config
})

// 响应拦截器
axios.interceptors.response.use(
  (res) => {
    // 成功的响应数据  服务器的相关的数据返回来之后，响应拦截器能够检测到，可以做一些事

    vant.Toast.clear()
    return res
  },
  (error) => {
    // 响应失败的时候的回调函数
    return Promise.reject(new Error(error))
  }
)

var http2 = {
  get: function (url, params) {
    return new Promise((resolve, reject) => {
      axios
        .get(url, {
          params: params,
        })
        .then((res) => {
          resolve(res.data)
        })
        .catch((err) => {
          reject(err.data)
        })
    })
  },
  post: function (
    { serviceId, interfacePublicKey, interfacePrivateKey, reqParams },
    fn
  ) {
    return new Promise((resolve, reject) => {
      axios
        .post('/gq/asd/common', {
          serviceId,
          interfacePublicKey,
          interfacePrivateKey,
          reqParams,
        })
        .then((res) => {
          // res.data = JSON.parse(res.data)
          let response = res.data.data
          if (response.statusCode >= 300 || response.status >= 300) {
            vant.Dialog.alert({
              title: '信息提示',
              message: response.message,
            })
            // 保持与http2.post相同的错误处理逻辑
            typeof fn === 'function' && fn(null)
            reject(response)
            return
          }
          typeof fn === 'function' && fn(response)
          resolve(response)
        })
        .catch((err) => {
          reject(err.response?.data || err.message)
        })
    })
  },
  postFile: function (url, params) {
    return new Promise((resolve, reject) => {
      axios({
        url,
        method: 'post',
        data: params,
        headers: {
          'Content-Type': 'application/json', // 'multipart/form-data;',
          Authorization: localStorage.getItem('Authorization'),
        },
      })
        .then((res) => {
          let response = res.data
          if (response.statusCode >= 300 || response.status >= 300) {
            // alert('系统发生错误')
            vant.Dialog.alert({
              title: '信息提示',
              message: response.message,
            })
            return
          }
          resolve(res.data)
        })
        .catch((err) => {
          reject(err.data)
        })
    })
  },
}
