'use strict';
//环境路径
var port = window.location.port;
var contextPath = '';
var comboChangeFlag = "true"

//Timstamp 函数， durian请求体用
function makeStamp(d) { // Date d
	var y = d.getFullYear(), M = d.getMonth() + 1, D = d.getDate(), h = d
			.getHours(), m = d.getMinutes(), s = d.getSeconds(), ss = d
			.getMilliseconds(),

	pad = function(x) {
		x = x + '';
		if (x.length === 1) {
			return '0' + x;
		}
		return x;
	};
	return y + pad(M) + pad(D) + pad(h) + pad(m) + pad(s) + pad(ss);
}
function getTargetDate(dayLength, type) {
    var dayLength = dayLength || 0;
    var tempDate = new Date();
    tempDate.setDate(tempDate.getDate() + dayLength);
    var year = tempDate.getFullYear();
    var month = tempDate.getMonth() + 1 < 10 ? "0" + (tempDate.getMonth() + 1) : tempDate.getMonth() + 1;
    var day = tempDate.getDate() < 10 ? "0" + tempDate.getDate() : tempDate.getDate();
    var time = '';
    time = type === "start" ? " 00:00:00" : " 23:59:59";
    return year + "-" + month + "-" + day + time;
}
// 时间 YYYY-MM-DD HH:MM
function getTargetDateYMDHM(dayLength, type) {
    var dayLength = dayLength || 0;
    var tempDate = new Date();
    tempDate.setDate(tempDate.getDate() + dayLength);
    var year = tempDate.getFullYear();
    var month = tempDate.getMonth() + 1 < 10 ? "0" + (tempDate.getMonth() + 1) : tempDate.getMonth() + 1;
    var day = tempDate.getDate() < 10 ? "0" + tempDate.getDate() : tempDate.getDate();
    var time = '';
    time = type === "start" ? " 00:00" : " 23:59";
    return year + "-" + month + "-" + day + time;
}

function getTargetDateYMD(dayLength, type) {
    var dayLength = dayLength || 0;
    var tempDate = new Date();
    tempDate.setDate(tempDate.getDate() + dayLength);
    var year = tempDate.getFullYear();
    var month = tempDate.getMonth() + 1 < 10 ? "0" + (tempDate.getMonth() + 1) : tempDate.getMonth() + 1;
    var day = tempDate.getDate() < 10 ? "0" + tempDate.getDate() : tempDate.getDate();
    return year + "-" + month + "-" + day;
}
function getTargetDateYM(dayLength, type) {
    var dayLength = dayLength || 0;
    var tempDate = new Date();
    tempDate.setDate(tempDate.getDate() + dayLength);
    var year = tempDate.getFullYear();
    var month = tempDate.getMonth() + 1 < 10 ? "0" + (tempDate.getMonth() + 1) : tempDate.getMonth() + 1;
//    var day = tempDate.getDate() < 10 ? "0" + tempDate.getDate() : tempDate.getDate();
    return year + "-" + month;
}
/**
 * 
 * @functionName: getPageName
 * @Description: get page name from URL 
 * @author: Double
 * 
 */
function getPageName() {
	var pathname = window.location.pathname;
	if (pathname) {
		pathname = pathname.split('/');
		return pathname[pathname.length - 1].split('.')[0];
	} else {
		return '';
	}
}

/**
 * 
 * @functionName: getOS
 * @Description: get operating system 
 * @author: Double
 * 
 */
function getOS() {
	var ua = navigator.userAgent.toLowerCase();
	if (ua.indexOf('windows nt 6.3') != -1) {
		return 'Windows 8';
	} else if (ua.indexOf('windows nt 6.1') != -1) {
		return 'Windows 7';
	} else if (ua.indexOf('windows nt 6.0') != -1) {
		return 'Windows Vista';
	} else if (ua.indexOf('windows nt 5.2') != -1) {
		return 'Windows 2003';
	} else if (ua.indexOf('windows nt 5.1') != -1) {
		return 'Windows XP';
	} else if (ua.indexOf('windows nt 5.0') != -1) {
		return 'Windows 2000';
	} else if (ua.indexOf('windows') != -1 || ua.indexOf('win32') != -1) {
		return 'Windows';
	} else if (ua.indexOf('macintosh') != -1 || ua.indexOf('mac os x') != -1) {
		return 'Macintosh';
	} else if (ua.indexOf('adobeair') != -1) {
		return 'Adobeair';
	} else if (ua.indexOf('linux') != -1) {
		return 'Linux';
	} else if (ua.indexOf('iphone') != -1) {
		return 'iPhone';
	} else if (ua.indexOf('ipad') != -1) {
		return 'iPad';
	} else if (ua.indexOf('android') != -1) {
		return 'Android';
	} else {
		return 'Unknow';
	}
}

/**
 * 
 * @functionName: getNavigator
 * @Description: get navigator 
 * @author: Double
 * 
 */
function getNavigator() {
	var ua = navigator.userAgent.toLowerCase();
	if (ua.indexOf('chrome') != -1) {
		return 'Chrome';
	} else if (ua.indexOf('firefox') != -1) {
		return 'Firefox';
	} else if (ua.indexOf('safari') != -1) {
		return 'Safari';
	} else if (ua.indexOf('opera') != -1) {
		return 'Opera';
	} else if(ua.indexOf('trident') != -1 && ua.indexOf('rv:11') != -1) {
		return 'IE 11.0';
	} else if (ua.indexOf('msie 10.0') != -1) {
		return 'IE 10.0';
	} else if (ua.indexOf('msie 9.0') != -1) {
		return 'IE 9.0';
	} else if (ua.indexOf('msie 8.0') != -1) {
		return 'IE 8.0';
	} else {
		return 'Unknow';
	}
}

/**
 * 
 * @functionName: isPC
 * @Description: 判断使用设备是否为PC 
 * @author: Double
 * 
 */
function isPC() {    
    var userAgentInfo = navigator.userAgent;  
    var agents = new Array('Android', 'iPhone', 'SymbianOS', 'Windows Phone', 'iPad', 'iPod');    
    var flag = true;    
    for (var v = 0; v < agents.length; v++) {    
        if (userAgentInfo.indexOf(agents[v]) > 0) {
        	flag = false; 
        	break;
        }    
    }    
    return flag;    
 }

/**
 * 
 * @functionName: getParameter
 * @Description: get parameter from URL 
 * @author: Double
 * 
 */
function getParameter(name) {
	var search = location.search;
	if(!search) {
		return false;
	}
	search = search.split('?')
	var data = search[1].split('=');
	if(search[1].indexOf(name) == (-1)) {
	    return '';
	    return;
	}
	if(search[1].indexOf('&') == (-1)) {
	    data = search[1].split('=');
	    return data[1];
	} else {
	    data = search[1].split('&'); 
	    for(var i = 0; i <= data.length - 1; i++){
	    	var l_data=data[i].split('=');
	        if(l_data[0] == name) {
	        	return l_data[1];
	        	break;
	        } else {
	        	continue;
	        }
	    }
	}
}

/**
 * 
 * @functionName: setParameter
 * @Description: set parameter to URL 
 * @author: Double
 * 
 */
function setParameter() {
	if (arguments.length >= 1) {
		var url = arguments[0], paramsObj = arguments[1];
		if (paramsObj) {
			var parameter = '';
			for (var x in paramsObj) {
				parameter += x + '=' + paramsObj[x] + '&';
			}
			url += '?' + parameter.substr(0, parameter.length - 1);
		}
		return url;
	} else {
		customUtil.layerAlert("setParameter : 参数错误, 支持2个参数(url-必填, paramsObj)", 2);
	}
}

/**
 * 
 * @functionName: trim
 * @Description: 由于IE8不支持trim方法，此处自定义 
 * @author: Double
 * 
 */
String.prototype.trim = function() {  
    return this.replace(/(^\s*)|(\s*$)/g, '');  
}

/**
 * @functionName: setCookie
 * @Description: set cookies 
 * @author: Double
 */
function setCookie(name, value, days) {
	if(name === 'whMap'|| name === 'columnArr'){ // 页面搜索条件记录 更改存取方式
		localStorage.setItem(name, value);
		return;
	}
	var len = arguments.length; 
	if (len == 2) {
	    var exp = new Date(); 
	    exp.setTime(exp.getTime() + 30*24*60*60*1000); 
	    document.cookie = name + '=' + escape (value) + ';expires=' + exp.toGMTString() + ';path=/'; 
	} else if (len == 3) {
		var exp = new Date();
		exp.setDate(exp.getDate() + parseInt(days));
		exp.setHours(1, 0, 0, 0);
		document.cookie = name + '=' + escape (value) + ';expires=' + exp.toGMTString() + ';path=/';
	} else {
		customUtil.layerAlert("SetCookie参数错误!", 2);
	}
} 

/**
 * 
 * @functionName: getCookie
 * @Description: get cookies 
 * @author: Double
 * 
 */
function getCookie(name) {
	if(name === 'whMap'|| name === 'columnArr'){ // 页面搜索条件记录 更改存取方式
		return localStorage.getItem(name);
	}
    var arr,reg=new RegExp('(^| )'+name+'=([^;]*)(;|$)');
    if(arr=document.cookie.match(reg))
        return unescape(arr[2]); 
    else 
        return null; 
} 

/**
 * 
 * @functionName: jumpBack
 * @Description: 从详情页跳回
 * @author: Double
 * 
 */
function jumpBack(destination) {
	var from = getParameter('from');
	if (!from || from == destination) {
		window.location.href = destination + '.html';
	} else {
	    window.close();
	}
}

/**
 * 
 * @functionName: delCookie
 * @Description: delete cookies 
 * @author: Double
 * 
 */
function delCookie(name) { 
    var exp = new Date(); 
    exp.setTime(exp.getTime() - 1); 
    var cval = getCookie(name); 
    if(cval != null) 
        document.cookie = name + '=' + cval + ';expires=' + exp.toGMTString() + ';path=/'; 
}

/**
 * 
 * @functionName: serializeObject
 * @Description: form序列化成object
 * @author: Double
 * @param: form
 */
var serializeObject = function() {
	if (arguments.length === 1) {
		var form = arguments[0], o = {};
		$.each(form.serializeArray(), function(index) {
			if (o[this['name']]) {
				o[this['name']] = o[this['name']] + ',' + this['value'].trim();
			} else {
				o[this['name']] = this['value'].trim();
			}
		});
		return o;
	} else {
		customUtil.layerAlert("serializeObject : 参数错误, 支持1个参数(form)", 2);
	}
};




/**
 * 
 * @functionName: formatDate
 * @Description: 格式化Date对象
 * @author: Double
 * @param: date, symbol-选填
 */
function formatDate() {  
	if (arguments.length > 0 && arguments.length < 3) {
		var date = arguments[0], symbol = (arguments[1] ? arguments[1] : '-');
		if (!date) {
			return '';
		}
		if (!(date instanceof Date)) {
			date = date.split(/\s/)[0].split('-');
			date = new Date(date[0], parseInt(date[1]) - 1, date[2]);
		}
		var year = date.getFullYear(), month = date.getMonth() + 1, day = date.getDate();
		month = month < 10 ? '0' + month : month;
		day = day < 10 ? '0' + day : day;
		return year + symbol +  month + symbol + day;
	} else {
		customUtil.layerAlert("formatDate : 参数错误, 支持2个参数(date, symbol-选填)", 2);
	}
}

/**
 * 
 * @functionName: formatTime
 * @Description: 格式化Date对象的time
 * @author: Double
 * @param: date
 */
function formatTime() {
	if (arguments.length === 1) {
		var date = arguments[0];
		if (!date) {
			return '';
		}
		if (!(date instanceof Date)) {
			date  = date.split(/\s/);
			if (!date[1]) {
				return '';
			}
			var time = date[1].split(':');
			if (!time[2]) {
				time[2] = '00';
			}
			date = date[0].split('-');
			date = new Date(date[0], parseInt(date[1]) - 1, date[2], time[0], time[1], time[2]);
		}
		var hour = date.getHours(), minute = date.getMinutes(), second = date.getSeconds();
		hour = hour < 10 ? '0' + hour : hour;
		minute = minute < 10 ? '0' + minute : minute;
		second = second < 10 ? '0' + second : second;
		return hour + ':' +  minute + ':' + second;
	} else {
		customUtil.layerAlert("formatTime : 参数错误, 支持1个参数(date)", 2);
	}
}


/**
 * 
 * @functionName: objToStr
 * @Description: 将JSON转换为String, 作为参数传进函数
 * @author: Double
 * @param: obj
 */
function objToStr(obj) {
	if (arguments.length === 1) {
		for(var key in obj) {
			if (typeof(obj[key]) === 'string' && obj[key].indexOf('[') > -1) {
				obj[key] = obj[key].replace(/\\\"/g, '\"');
				obj[key] = obj[key].replace(/\"/g, '\\\"');
			}
		}
		return JSON.stringify(obj).replace(/\s/g, '&nbsp;');
	} else {
		customUtil.layerAlert("objToStr : 参数错误, 支持1个参数(obj)", 2);
	}
}




/**
 * 
 * @functionName: 
 * @Description: 获取url页面名称方法 
 * @author: haliluya
 * @param: date
 * @desc ： 2017-2-15 09:37:28
 */
function getPageName() {
	var pageN = window.location.pathname;
	pageN = pageN.substring(pageN.lastIndexOf("/")+1,pageN.indexOf("."));
	if(pageN) return pageN;
}
/**
 * 根据一个link字符串获取页面的名称
 */
function getPageNameByLink(link){
	var link = link ? link : 'index';
	return link.substring(link.lastIndexOf("/") + 1, link.indexOf("."));
}

/**
 * @desc 获取当前日期（0）、前几天（负数）、后几天(正数)
 * @param day
 * @returns
 */
function getDay(day){
    var today = new Date();
    var milliseconds = today.getTime() + 1000*60*60*24*day;
    today.setTime(milliseconds);
    var tYear = today.getFullYear();
    var tMonth = today.getMonth();
    var tDate = today.getDate();
    tMonth = doHandleMonth(tMonth + 1);
    tDate = doHandleMonth(tDate);
    return tYear+"-"+tMonth+"-"+tDate;
}
function doHandleMonth(month){
    var m = month;
    if(month.toString().length == 1){
     m = "0" + month;
    }
    return m;
}
function blankReplace(str){
	return str || ''; 
}	
// 日期 年月日时分秒 2018-08-01 22:22:22
function getYmdHms4laydate(d) { // Date d
	var y = d.getFullYear(), M = d.getMonth() + 1, D = d.getDate(), h = d
			.getHours(), mi = d.getMinutes(), s = d.getSeconds();
	var pad = function(x) {
		x = x + '';
		if (x.length === 1) {
			return '0' + x;
		}
		return x;
	};
	return [y, pad(M), pad(D)].join('-') + ' ' + [pad(h), pad(mi), pad(s)].join(':');
}
//日期 年月日时分 2018-08-01 22:22
function getYmdHm4laydate(d) { // Date d
	var y = d.getFullYear(), M = d.getMonth() + 1, D = d.getDate(), h = d
			.getHours(), mi = d.getMinutes();
	var pad = function(x) {
		x = x + '';
		if (x.length === 1) {
			return '0' + x;
		}
		return x;
	};
	return [y, pad(M), pad(D)].join('-') + ' ' + [pad(h), pad(mi)].join(':');
}

//日期 年月日时分 2018-8-1
function formatDateByLaydate(d){
	var y = d.getFullYear(), M = d.getMonth() + 1, D = d.getDate();
	return [y, M, D].join('-');
}

//日期 年月日时分 2018-08-01
function formatDateByLaydate1(d){
	var y = d.getFullYear(), M = d.getMonth() + 1, D = d.getDate();
	var pad = function(x) {
		x = x + '';
		if (x.length === 1) {
			return '0' + x;
		}
		return x;
	};
	return [y, pad(M), pad(D)].join('-');
}

// datagrid 列内容鼠标悬浮详情显示
function getMore4title(value){
	if(value !== 0){
		value = (value)|| "";
	}
	return '<span title="'+ value +'">'+ value +'</span>';
}

//datagrid 列内容鼠标悬浮详情显示需要过滤<时
function getMore4titleForExp(value){
	if(value !== 0){
		value = (value)|| "";
		if(isString(value)){
			value=value.replace(/</g,"&lt;");
			value=value.replace(/\"/g,"”");	
		}
	}
	return '<span title="'+ value +'">'+ value +'</span>';
}
function isString(str){
	return (typeof str=='string')&&str.constructor==String;
}

//获取商品总金额
function getTotalPInfo4pGrid(target){
	var rows = $(target).datagrid('getData').rows;
	var sumMoney = 0;
	if(rows.length){
		rows.forEach(function(item, index){
			sumMoney += ((item.productPrice || 0) * (item.productAmount || 0)) * 1;
		})
	}
	return {
		productTotalMoney: sumMoney,
		total: rows.length
	}
}
//获取包裹列表所有包裹的总重量和总数目
function getTotalW4pGrid(target){
	var rows = $(target).datagrid('getData').rows;
	var sumWeight=0, sumCnt = 0;
	if(rows.length){
		rows.forEach(function(item, index){
			sumWeight += (item.packageWeight || 0) * 1;
		})
	}
	return {
		packageTotalW: sumWeight.toFixed(2),
		total: rows.length
	}
}
// 数字科学计数显示
function numFormat(s, n) { 
	if(!s){return 0}
	n = n > 0 && n <= 20 ? n : 2; 
	s = parseInt((s + "").replace(/[^\d\.-]/g, "")).toFixed(n) + ""; 
	var l = s.split(".")[0].split("").reverse(), r = s.split(".")[1]; 
	var t = ""; 
	for (var i = 0; i < l.length; i++) { 
		t += l[i] + ((i + 1) % 3 == 0 && (i + 1) != l.length ? "," : ""); 
	} 
	return t.split("").reverse().join(""); 
}

/**
 * 
 * @param path
 * @returns 下载文件 更新版本号
 */
function downloadFile(path){
	location.href = contextPath + path +'?rev='+ (+new Date());
}

/**
 * 跳转页面 更新版本号
 * @param path
 * @returns
 * @demo  navigatePage('/warehouse/company/companyDetail.html?companyId=1002');
 */
function navigatePage(path){
	if(!path){return;}
	var url = contextPath;
	if(path.indexOf('?') > -1){ // 带有参数
		url += path + '&rev='+ (+new Date())
	}else{
		url += path + '?rev='+ (+new Date())
	}
	location.href = url;
}

