/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				form: {
					// 检查日期
					hdInspectDate: '',//2024-03-08 00:00:00',
					// 检查人员
					hdInspectExpert: '',//'发发发',
					// 隐患类型
					hdLevel: '1',
					// 安全类别
					curSelectSecType: '',//'安全资料类',
					// 安全检查类别
					curSelectSecCheckTypeReplace: '',//'测试资料',
					// 当前选择的安全检查内容
					curSelectCheckContent: '',//'测试内容',
					// 发现问题
					hdName: '',//'测试问题',
					// 隐患描述
					hdDesc: '',//"水电费双方都",
					// 检查依据
					basis: '',//'测试依据',
					// 隐患整改建议
					suggestion: '',//'测试建议',
					// 隐患图片
					// hdPic: null,
					// 隐患整改日期
					hdRectificationDate: '',//'2024-03-08',
					// 隐患整改图片
					// hdRectificationPic: null,
					// 整改图片文件路径
					rectFilePath: '',
					// 审核人
					hdAcceptancePerson: "刘德华",
					hdRectificationRecord: '24年02月22日 审核未通过;24年02月22日 审核未通过',
					hdStatus: 0, // 整改中
				},
				// 企业id
				companyId: localStorage.getItem('companyId'),
				editAble: true,

				// 安全类别列表数据
				secType: [{
					name: '安全资料类',
				}, {
					name: '现场检查类',
				}],
				showPopup4secType: false,

				// 安全检查类别列表数据
				secCheckTypeReplace: [],
				showPopup4secCheckTypeReplace: false,
				// 安全检查内容列表数据
				secCheckContent: [],
				showPopup4secCheckContent: false,
				// 安全发现问题列表数据
				secCheckDiscover: [],
				showPopup4secCheckDiscover: false,

				// 检查日期的模态框
				hdInspectDateModel: '', // 时间的临时model值
				showPopup4hdInspectDate: false,

				// 整改日期模态框
				hdRectificationDateModel: '',
				showPopup4hdRectificationDate: false,


				fileList: [],
				// columns4findQuestion: ['杭州', '宁波', '温州', '绍兴', '湖州', '嘉兴', '金华', '衢州'],
				// findQuestion: '',



			}
		},
		mounted() {
			if(getParameter('type') === 'detail'){
				this.editAble = false
				this.detail()
			}else if(getParameter('type') === 'edit'){
				this.editAble = true
				this.detail()
			}else{ // 新增
				this.editAble = true
				this.resetData()
			}
		},

		methods: {
			resetData() {
			  // 使用 Object.assign 来重写 this.$data，以达到重置 data 的目的
			  Object.assign(this.$data, this.$options.data.call(this));
			},
			showPopup(popupType){
				if(this.editAble){
					this[popupType] = true
				}
			},
			detail(){
				var hdId = getParameter('companyId')
				http.get('/api/thHiddenDanger',{
					page: 0,// 每次请求增加下一页
					size: 1,
					companyId: getParameter('companyId'),
					hdId: getParameter('hdId'),
					sort: 'hdId,asc',
				}).then((res)=>{
					console.log('响应结果', res.content)
					this.form = res.content[0]
					this.form.hdLevel = this.form.hdLevel+''
					
					this.form.curSelectSecType = this.form.type // 安全类别
					this.form.curSelectSecCheckTypeReplace = this.form.category // 安全检查类别
					this.form.curSelectCheckContent = this.form.inspectionContent // 安全检查内容
					this.form.hdName = this.form.hdName // 安全发现问题
					// 详情图片设置
					this.fileList.push({
						content: 'data:image/jpg;base64,' + this.form.hdPic
					})
				})
			},
			submit() {
				if (!this.form.hdInspectDate) {
					vant.Dialog.alert({
						message: '检查日期不能为空',
					})
					return
				}
				if (!this.form.curSelectSecType) {
					vant.Dialog.alert({
						message: '请选择安全类别',
					})
					return;
				}
				if (!this.form.curSelectSecCheckTypeReplace) {
					vant.Dialog.alert({
						message: '请选择安全检查类别',
					})
					return;
				}
				if (!this.form.curSelectCheckContent) {
					vant.Dialog.alert({
						message: '请选择安全检查内容',
					})
					return;
				}
				if (!this.form.hdName) {
					vant.Dialog.alert({
						message: '请选择发现问题',
					})
					return;
				}
				if (!this.fileList.length) {
					vant.Dialog.alert({
						message: '没有隐患照片',
					})
					return
				}

				let formData = new FormData()
				for (const key of Object.keys(this.form)) {
					formData.append(key, this.form[key]);
				  }

				formData.append('companyId', getParameter('companyId'))
				
				formData.delete('hdPic');
				formData.delete('hdRectificationPic');
				formData.delete('recDeadLine');
				
				if (!this.form.comment) {
					delete formData.comment
				}
				if (!formData.hdInspectDate) {
					delete formData.hdInspectDate
				}
				if (!formData.hdRectificationDate) {
					delete formData.hdRectificationDate
				}
				
				if(this.fileList[0].file){ // 只有file存在的时候，证明新改过的图片，需要传参更新，否则不更新（回显的时候filelist只有content属性有值）
					formData.append('hdPic', this.fileList[0].file )
				}
				
				var url = this.form.hdId ? "/api/thHiddenDanger/update" : "/api/thHiddenDanger"
         
				http.postFile(url, formData).then((res) => {
					console.log('添加结果', res)
					vant.Toast({
						message: '操作成功',
					})
					if(!this.form.hdId){ // 添加时则
						location.reload()
					}
				})
			},
			formatDate(date, type) {
				var ymd = `${date.getFullYear() + 1}-${((date.getMonth()+1)>9?'':'0')+(date.getMonth() + 1)}-${(date.getDate()>9?'':'0')+date.getDate()}`;
				if(type === 'YYYY-MM-DD HH:MM:SS'){
					return ymd +' 00:00:00';
				}
				return ymd
			},
			onConfirm4secType(value, index) {
				console.log('value', value)
				this.form.curSelectSecType = value.name
				this.showPopup4secType = false

				/**
					逻辑处理相关
					1、清理安全检查类别、检查内容和发现问题的相关信息
					2、请求获取下级列表数据 检查类别
				 */
				this.secCheckTypeReplace = []
				this.secCheckContent = []
				this.secCheckDiscover = []
				// 安全检查类别
				this.form.curSelectSecCheckTypeReplace = ''
				// 当前选择的安全检查内容
				this.form.curSelectCheckContent = ''
				// 发现问
				this.form.hdName = ''

				http.get('/api/enterpriseSafetyInspectionContent', {
					county: localStorage.getItem('appCounty'),
					level: 1,
					type: value.name,
					page: 0,
					size: 99999,
				}).then((res) => {
					this.secCheckTypeReplace = res.content || []

				})



			},
			onConfirm4secCheckTypeReplace(value, index) {
				console.log('value', value)
				this.form.curSelectSecCheckTypeReplace = value.name
				this.showPopup4secCheckTypeReplace = false

				/**
					逻辑处理相关
					1、清理安全检查类别、检查内容和发现问题的相关信息
					2、请求获取下级列表数据 检查类别
				 */
				this.secCheckContent = []
				this.secCheckDiscover = []
				// 当前选择的安全检查内容
				this.form.curSelectCheckContent = ''
				// 发现问题
				this.form.hdName = ''

				http.get('/api/enterpriseSafetyInspectionContent', {
					county: localStorage.getItem('appCounty'),
					level: 2,
					pid: value.id,
					page: 0,
					size: 99999,
				}).then((res) => {
					this.secCheckContent = res.content || []
				})
			},
			onConfirm4secCheckContent(value) {
				this.form.curSelectCheckContent = value.name
				this.showPopup4secCheckContent = false

				/**
					逻辑处理相关
					1、清理安全检查类别、检查内容和发现问题的相关信息
					2、请求获取下级列表数据 检查类别
				 */
				this.secCheckDiscover = []
				// 发现问题
				this.form.hdName = ''

				http.get('/api/enterpriseSafetyMatter', {
					inspectionContentId: value.id,
					page: 0,
					size: 99999,
				}).then((res) => {
					this.secCheckDiscover = res.content || []
				})
			},
			onConfirm4secCheckDiscover(value) {
				this.form.hdName = value.name
				this.showPopup4secCheckDiscover = false

				// 给检查依据和整改建议赋默认值
				this.form.basis = value.basis
				this.form.suggestion = value.suggestion
			},

			confirm4hdInspectDate(value) {
				console.log('value', value)
				this.form.hdInspectDate = this.formatDate(new Date(value), 'YYYY-MM-DD HH:MM:SS')
				this.showPopup4hdInspectDate = false

			},
			confirm4hdRectificationDate(value) {
				console.log('value', value)
				this.form.hdRectificationDate = this.formatDate(new Date(value))
				this.showPopup4hdRectificationDate = false

			},
		},
	});
});