/**
 * author: dabao
 */
var VUE = null
window.addEventListener("load", function() {
	VUE = new Vue({
		el: '#app',
		data() {
			return {
				value: '',
				list: [],
				loading: false,
				finished: false,
				page: 0,
				size: 10,
				total: 0,
				companyName: '',
				curVerifyStatus: '',
				curVerifyStatusVal: '',
				showPopup4verifyStatus: false,
				verifyStatusList: [{
						name: "待审核",
						value: 3,
					},
					{
						name: "审核已通过",
						value: 1,
					},
					{
						name: "审核未通过",
						value: 2,
					},
				],
				
			}
		},
		mounted() {
			this.getList()
		},
		methods: {
			resetSearchForm(){
				this.page = 0
				this.size = 20
				this.total = 0
				this.list = []
				this.finished = false;
			},
			showPopup(popupType){
				this[popupType] = true
			},
			onConfirm4verifyStatus(item){
				this.showPopup4verifyStatus = false
				this.resetSearchForm()
				this.curVerifyStatus = item.name
				this.curVerifyStatusVal = item.value
				this.getList()
				
			},
			onClear() {
				this.resetSearchForm()
				this.getList()
			},
			onSearch(val) {
				this.resetSearchForm()
				console.log('search', val)
				this.getList()
			},
			nav(item) {
				// location.href='./yh-list.html'
			},
			add() {
				location.href = './yh-list-detail.html?companyId=' + getParameter('companyId') +
					'&type=add'
			},
			detail(item) {
				location.href = './yh-list-detail.html?companyId=' + getParameter('companyId') +
					'&hdId=' + item.hdId + '&type=detail'
			},
			edit(item) {
				location.href = './yh-list-detail.html?companyId=' + getParameter('companyId') +
					'&hdId=' + item.hdId + '&type=edit'
			},
			getList() {
				http.get('/api/hiddenDangerToVerify', {
					page: this.page++, // 每次请求增加下一页
					size: this.size,
					county: localStorage.getItem('appCounty'),
					verifyState: this.curVerifyStatusVal,
					enName: this.companyName,
					sort: 'verify_status,asc',
				}).then((res) => {

					this.loading = false; // 加载状态结束

					console.log('响应结果', res.content)
					this.list.push(...res.content);
					this.total = res.totalElements
					console.log('响应结果list', this.list)

					console.log('响应结果totalElements', res.totalElements)
					if (this.page * this.size >= this.total) {
						this.finished = true; // 下滑不在刷新数据
					}
				})

			}
		},
	});
});