import request from '@/utils/request'

// 查询设备信息列表
export function listDrybeachequipinfor(query) {
  return request({
    url: '/business/drybeachequipinfor/list',
    method: 'get',
    params: query
  })
}

// 查询设备信息所有列表
export function listAllDrybeachequipinfor(query) {
  return request({
    url: '/business/drybeachequipinfor/listAll',
    method: 'get',
    params: query
  })
}

// 查询设备信息详细
export function getDrybeachequipinfor(id) {
  return request({
    url: '/business/drybeachequipinfor/getInfo/' + id,
    method: 'get'
  })
}

// 新增设备信息
export function addDrybeachequipinfor(data) {
  return request({
    url: '/business/drybeachequipinfor/add',
    method: 'post',
    data: data
  })
}

// 修改设备信息
export function updateDrybeachequipinfor(data) {
  return request({
    url: '/business/drybeachequipinfor/edit',
    method: 'post',
    data: data
  })
}

// 删除设备信息
export function delDrybeachequipinfor(id) {
  return request({
    url: '/business/drybeachequipinfor',
    method: 'delete',
    data:{
        id
    }
  })
}